<?php

/***************************************************************************

 m_galleryform.php
 ------------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

// Localisation variables (used for default values)
// Change these to suit your site preferences
//
$expiryperiod = 'd';			// Time period to calculate the expiry date (based on today's date)
$expirynumber = 0;


$GLOBALS["ModuleName"] = 'gallery';
include("moduleref.php");

$GLOBALS["rootdp"] = '../../';
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");

include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ($GLOBALS["rootdp"].$GLOBALS["admin_home"]."adminfunctions.php");
include ($GLOBALS["rootdp"].$GLOBALS["modules_home"]."modfunctions.php");
include ($GLOBALS["rootdp"].$GLOBALS["language_home"].$GLOBALS["gsLanguage"]."/lang_admin.php");
include ($GLOBALS["rootdp"].$GLOBALS["language_home"].$GLOBALS["gsLanguage"]."/lang_main.php");
include_languagefile ($GLOBALS["modules_home"].$GLOBALS["ModuleRef"].'/',$GLOBALS["gsLanguage"],'lang_gallery.php');


// Security vet.
// Start by setting all security access to false.
// Do it in the code to overwrite any spurious values that a hacker may
//    have tried to pass in the url
$GLOBALS["specialedit"] = $GLOBALS["canedit"] = $GLOBALS["canadd"] = $GLOBALS["canview"] = False;
$GLOBALS["fieldstatus"] = '';

// Validate the user's level of access for this form.
$GLOBALS["form"] = 'subcontent';
$GLOBALS["validaccess"] = VerifyAdminLogin();
$GLOBALS["specialedit"] = True;


GetModuleData($GLOBALS["ModuleRef"]);

// If we've been passed the request from the banner list, then we
//    read banner data from the database for an edit request, or skip
//    if this is an 'add new' request
if ($HTTP_GET_VARS["galleryID"] != "") {
   $HTTP_POST_VARS["galleryID"] = $HTTP_GET_VARS["galleryID"];
   $HTTP_POST_VARS["page"] = $HTTP_GET_VARS["page"];
   GetGlobalData();
} else {
   $timenow = time();			// Calculate the default expiry date
   $GLOBALS["DefExpDate"] = date('Y-m-d H:i:s',DateAdd($expiryperiod,$expirynumber,$timenow));
   GetFormData;
}

if ($HTTP_POST_VARS["submitted"] == "yes") {
   Addgallery();
   Header("Location: ".BuildLink('m_'.$GLOBALS["ModuleName"].'.php')."&page=".$HTTP_POST_VARS["page"]);
}

frmgalleryForm();


function frmgalleryForm()
{
   global $HTTP_POST_VARS;

   adminformheader();
   adminformopen('PublishDay');
   adminformtitle(2,$GLOBALS["tFormTitle"]);

   if ($GLOBALS["scUseCategories"] == 'Y') {
      ?>
      <tr class="tablecontent">
          <?php FieldHeading("Category","catcode"); ?>
          <td valign="top" class="content">
              <select name="catcode" size="1">
                  <option value="0">
                  <?php RenderAllCategories($GLOBALS["gsCatCode"]); ?>
              </select>
          </td>
      </tr>
      <?php
   } else {
      ?><input type="hidden" name="catcode" value="0"><?php
   }
   ?>
   <tr class="tablecontent">
       <?php FieldHeading("PublishDate","PublishDay"); ?>
       <td valign="top" class="content">
			<?php admindatedisplay('Publish',$GLOBALS["gsPublishDate"]); ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("Title","title"); ?>
       <td valign="top" class="content">
           <input type="text" name="title" size="50" value="<?php echo htmlspecialchars($GLOBALS["gsTitle"]) ?>" maxlength=255<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("Artist","artist"); ?>
       <td valign="top" class="content">
           <input type="text" name="artist" size="50" value="<?php echo htmlspecialchars($GLOBALS["gsArtist"]) ?>" maxlength=255<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("Filename","filename"); ?>
       <td valign="top" class="content">
           <input type="text" name="filename" size="50" value="<?php echo htmlspecialchars($GLOBALS["gsFilename"]) ?>" maxlength=255<?php echo $GLOBALS["fieldstatus"]; ?>>
           <?php adminimagedisplay('filename',$GLOBALS["gsFilename"],$GLOBALS["tShowImage"]); ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("Caption","caption"); ?>
       <td valign="top" class="content">
           <?php EditButtons("Caption","caption"); ?>
           <textarea rows="4" name="caption" cols="66"<?php echo $GLOBALS["fieldstatus"]; ?>><?php echo htmlspecialchars($GLOBALS["gsCaption"]); ?></textarea>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("CName","contactname"); ?>
       <td valign="top" class="content">
           <input type="text" name="contactname" size="50" value="<?php echo htmlspecialchars($GLOBALS["gsContactName"]) ?>" maxlength=255<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("CEMail","contactemail"); ?>
       <td valign="top" class="content">
           <input type="text" name="contactemail" size="60" value="<?php echo htmlspecialchars($GLOBALS["gsContactEmail"]) ?>" maxlength=255<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("WebRef","web_page"); ?>
       <td valign="top" class="content">
           <input type="text" name="web_page" size="70" value="<?php echo htmlspecialchars($GLOBALS["gsWeb_Page"]) ?>" maxlength=255<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <?php
   adminformsavebar(2,'m_gallery.php');
   if ($GLOBALS["specialedit"] == True)
   {
//      adminhelpmsg(2);
      ?><input type="hidden" name="galleryID" value="<?php echo $HTTP_POST_VARS["galleryID"]; ?>"><?php
   }
   adminformclose();
} // function frmgalleryForm()


function Addgallery()
{
   global $HTTP_POST_VARS;

   $publishisodate = dbDateTime(sprintf("%04d-%02d-%02d 00:00:00", $HTTP_POST_VARS["PublishYear"], $HTTP_POST_VARS["PublishMonth"], $HTTP_POST_VARS["PublishDay"]));
   $updateisodate  = dbDateTime(sprintf("%04d-%02d-%02d %02d:%02d:%02d", strftime("%Y"), strftime("%m"), strftime("%d"), strftime("%H"), strftime("%M"), strftime("%S")));
   $authorid = lGetAuthorID();

   $sTitle    = dbString($HTTP_POST_VARS["title"]);
   $sArtist   = dbString($HTTP_POST_VARS["artist"]);
   $sFilename = dbString($HTTP_POST_VARS["filename"]);
   $sCaption  = dbString($HTTP_POST_VARS["caption"]);

   if ($GLOBALS["scValidate"] == 'Y') { $scValid = 0;
   } else { $scValid = 1; }

   if ($HTTP_POST_VARS["galleryID"] != "") {
      $strQuery = "UPDATE ".$GLOBALS["scTable"]." SET title='".$sTitle."', artist='".$sArtist."', filename='".$sFilename."', publishdate='".$publishisodate."', contactname='".$HTTP_POST_VARS["contactname"]."', contactemail='".$HTTP_POST_VARS["contactemail"]."', web_page='".$HTTP_POST_VARS["web_page"]."', caption='".$sCaption."', updatedate='".$updateisodate."', authorid='".$authorid."', catid='".$HTTP_POST_VARS["catcode"]."' WHERE galleryid='".$HTTP_POST_VARS["galleryID"]."'";
   } else {
      $strQuery = "INSERT INTO ".$GLOBALS["scTable"]." VALUES('', '".$sTitle."', '".$sFilename."', '".$sArtist."', '".$publishisodate."', '".$HTTP_POST_VARS["contactname"]."', '".$HTTP_POST_VARS["contactemail"]."', '".$HTTP_POST_VARS["web_page"]."', '".$sCaption."', ".$scValid.", '".$authorid."', '".$updateisodate."', '".$HTTP_POST_VARS["catcode"]."')";
   }
   $result = dbExecute($strQuery,true);
   dbCommit();
}


function GetGlobalData()
{
   global $EZ_SESSION_VARS, $HTTP_GET_VARS, $HTTP_POST_VARS;

   $strQuery="SELECT * FROM ".$GLOBALS["scTable"]." WHERE galleryid='".$HTTP_GET_VARS["galleryID"]."'";
   $result = dbRetrieve($strQuery,true,0,0);
   $rs     = dbFetch($result);

   $GLOBALS["gsTitle"]         = $rs["title"];
   $GLOBALS["gsArtist"]        = $rs["artist"];
   $GLOBALS["gsFilename"]      = $rs["filename"];
   $GLOBALS["gsPublishDate"]   = $rs["publishdate"];
   $GLOBALS["gsContactName"]   = $rs["contactname"];
   $GLOBALS["gsContactEmail"]  = $rs["contactemail"];
   $GLOBALS["gsWeb_Page"]      = $rs["web_page"];
   $GLOBALS["gsCaption"]       = $rs["caption"];
   $GLOBALS["gsCatCode"]       = $rs["catid"];

   $HTTP_POST_VARS["authorid"] = $rs["authorid"];
   if ($rs["authorid"] == $EZ_SESSION_VARS["UserID"]) {
      $GLOBALS["specialedit"] = True;
      $GLOBALS["fieldstatus"] = '';
   }
} // function GetGlobalData()


function GetFormData()
{
   global $EZ_SESSION_VARS, $HTTP_POST_VARS;

   $publishisodate = sprintf("%04d-%02d-%02d", $HTTP_POST_VARS["PublishYear"], $HTTP_POST_VARS["PublishMonth"], $HTTP_POST_VARS["PublishDay"]);
   $expireisodate = sprintf("%04d-%02d-%02d", $HTTP_POST_VARS["ExpireYear"], $HTTP_POST_VARS["ExpireMonth"], $HTTP_POST_VARS["ExpireDay"]);

   $GLOBALS["gsTitle"]         = $HTTP_POST_VARS["title"];
   $GLOBALS["gsArtist"]        = $HTTP_POST_VARS["artist"];
   $GLOBALS["gsFilename"]      = $HTTP_POST_VARS["filename"];
   $GLOBALS["gsPublishDate"]   = $publishisodate;
   $GLOBALS["gsContactName"]   = $HTTP_POST_VARS["contactname"];
   $GLOBALS["gsContactEmail"]  = $HTTP_POST_VARS["contactemail"];
   $GLOBALS["gsWeb_Page"]      = $HTTP_POST_VARS["web_page"];
   $GLOBALS["gsCaption"]       = $HTTP_POST_VARS["caption"];
   $GLOBALS["gsCatCode"]       = $HTTP_POST_VARS["catcode"];

   if ($HTTP_POST_VARS["authorid"] == $EZ_SESSION_VARS["UserID"]) {
      $GLOBALS["specialedit"] = True;
      $GLOBALS["fieldstatus"] = '';
   }
} // function GetFormData()

ModuleJavaFunctions();

?>
