<?php

/***************************************************************************

 submit_gallery.php
 -------------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/


global $HTTP_SERVER_VARS;
if ( (substr($HTTP_SERVER_VARS["PHP_SELF"],-11) == 'control.php') ||
	 (substr($HTTP_SERVER_VARS["PHP_SELF"],-10) == 'module.php') ||
	 (substr($HTTP_SERVER_VARS["PHP_SELF"],-16) == 'showcontents.php') ) {
	 require_once('./modules/moduleSec.php');
} else {
	require_once('../moduleSec.php');
}

// Localisation variables (used for default values)
// Change these to suit your site preferences
//
$expiryperiod = 'm';			// Time period to calculate the banner expiry date (based on today's date)
$expirynumber = 1;


$GLOBALS["ModuleName"] = 'gallery';

include_once ($GLOBALS["language_home"].$GLOBALS["gsLanguage"]."/lang_admin.php");
include_once ($GLOBALS["language_home"].$GLOBALS["gsLanguage"]."/lang_main.php");
include_languagefile ($GLOBALS["modules_home"].$GLOBALS["ModuleName"].'/',$GLOBALS["gsLanguage"],"lang_".$GLOBALS["ModuleName"].".php");

$validentry = True;
if ($GLOBALS["scLoginRequired"] == 'Y')
{
   $validentry = VerifySubmoduleLogin($GLOBALS["tSubmitGallery"]);
}


if ($validentry)
{
   $timenow = time();			// Calculate the default expiry date
   $GLOBALS["DefExpDate"] = DateAdd($expiryperiod,$expirynumber,$timenow);

   if ($HTTP_POST_VARS["submitted"] == "yes")
   {
      AddGallery();
      SubModuleReturn('showgallery.php', $GLOBALS["tGalleryPage"],'');
   }
   else
   {
      frmGalleryForm();
   }
}


function frmGalleryForm()
{
   global $EZ_SESSION_VARS, $HTTP_POST_VARS;

   SubModFormHeader();
   adminformtitle(2,$GLOBALS["tSubmitFormTitle"]);
	$GLOBALS["specialedit"] = True;

   if ($GLOBALS["scUseCategories"] == 'Y')
   {
      ?>
      <tr class="tablecontent">
          <?php FieldHeading("Category","catcode"); ?>
          <td valign="top" class="content">
              <select name="catcode" size="1">
                  <option value="0">
                  <?php RenderCategories($GLOBALS["gsCatCode"]); ?>
              </select>
          </td>
      </tr>
      <?php
   }
   else
   {
      ?><input type="hidden" name="catcode" value="0"><?php
   }
   ?>
   <tr class="tablecontent">
       <?php FieldHeading("PublishDate","PublishDay"); ?>
       <td valign="top" class="content">
			<?php admindatedisplay('Publish'); ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("Title","title"); ?>
       <td valign="top" class="content">
           <input type="text" name="title" size="50" value="<?php echo htmlspecialchars($GLOBALS["gsTitle"]) ?>" maxlength=255>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("Artist","artist"); ?>
       <td valign="top" class="content">
           <input type="text" name="artist" size="50" value="<?php echo htmlspecialchars($GLOBALS["gsArtist"]) ?>" maxlength=255<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("Filename","filename"); ?>
       <td valign="top" class="content">
           <input type="text" name="filename" size="50" value="<?php echo htmlspecialchars($GLOBALS["gsFilename"]) ?>" maxlength=255>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("Caption","caption"); ?>
       <td valign="top" class="content">
           <?php EditButtons("Caption","caption"); ?>
           <textarea rows="3" name="caption" cols="44"><?php echo htmlspecialchars($GLOBALS["gsCaption"]); ?></textarea>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("CName","contactname"); ?>
       <td valign="top" class="content">
           <input type="text" name="contactname" size="50" value="<?php echo htmlspecialchars($GLOBALS["gsContactName"]) ?>" maxlength=255>
      </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("CEMail","contactemail"); ?>
       <td valign="top" class="content">
           <input type="text" name="contactemail" size="50" value="<?php echo htmlspecialchars($GLOBALS["gsContactEmail"]) ?>" maxlength=255>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("WebRef","web_page"); ?>
       <td valign="top" class="content">
           <input type="text" name="web_page" size="50" value="<?php echo htmlspecialchars($GLOBALS["gsWeb_Page"]) ?>" maxlength=255>
       </td>
   </tr>
   <?php SubModFormFooter(2); ?>
   <input type="hidden" name="GalleryID" value="<?php echo $HTTP_POST_VARS["GalleryID"]; ?>">
   <?php modformclose($GLOBALS["tSubmitGallery"]); ?>
   </td></tr></table>
   </form>
   </td></tr></table>
   <?php
} // function frmGalleryForm()


function AddGallery()
{
   global $HTTP_POST_VARS;

   $publishisodate = dbDateTime(sprintf("%04d-%02d-%02d 00:00:00", $HTTP_POST_VARS["PublishYear"], $HTTP_POST_VARS["PublishMonth"], $HTTP_POST_VARS["PublishDay"]));
   $updateisodate  = dbDateTime(sprintf("%04d-%02d-%02d %02d:%02d:%02d", strftime("%Y"), strftime("%m"), strftime("%d"), strftime("%H"), strftime("%M"), strftime("%S")));
   $authorid = lGetAuthorID();

   $sTitle    = dbString($HTTP_POST_VARS["title"]);
   $sArtist   = dbString($HTTP_POST_VARS["artist"]);
   $sFilename = dbString($HTTP_POST_VARS["filename"]);
   $sCaption  = dbString($HTTP_POST_VARS["caption"]);

   if ($GLOBALS["scValidate"] == 'Y') { $scValid = 0; }
   else { $scValid = 1; }
   $sCatId = 0;

   $strQuery = "INSERT INTO ".$GLOBALS["scTable"]." VALUES('', '".$sTitle."', '".$sFilename."', '".$sArtist."', '".$publishisodate."', '".$HTTP_POST_VARS["contactname"]."', '".$HTTP_POST_VARS["contactemail"]."', '".$HTTP_POST_VARS["web_page"]."', '".$sCaption."', ".$scValid.", '".$authorid."', '".$updateisodate."', '".$HTTP_POST_VARS["catcode"]."')";
   $result = dbExecute($strQuery,true);
   dbCommit();
} // function AddGallery()


ModuleJavaFunctions();

?>
