<?php

/***************************************************************************

 m_linksform.php
 ---------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

// Localisation variables (used for default values)
// Change these to suit your site preferences
//


$GLOBALS["ModuleName"] = 'links';
include("moduleref.php");


$GLOBALS["rootdp"] = '../../';
include_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");

include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ($GLOBALS["rootdp"].$GLOBALS["admin_home"]."adminfunctions.php");
include ($GLOBALS["rootdp"].$GLOBALS["admin_home"]."compile.php");
include ($GLOBALS["rootdp"].$GLOBALS["modules_home"]."modfunctions.php");
include ($GLOBALS["rootdp"].$GLOBALS["language_home"].$GLOBALS["gsLanguage"]."/lang_admin.php");
include ($GLOBALS["rootdp"].$GLOBALS["language_home"].$GLOBALS["gsLanguage"]."/lang_main.php");
include_languagefile ($GLOBALS["modules_home"].$GLOBALS["ModuleRef"].'/',$GLOBALS["gsLanguage"],'lang_links.php');


// Security vet.
// Start by setting all security access to false.
// Do it in the code to overwrite any spurious values that a hacker may
//    have tried to pass in the url
$GLOBALS["specialedit"] = $GLOBALS["canedit"] = $GLOBALS["canadd"] = $GLOBALS["canview"] = False;
$GLOBALS["fieldstatus"] = '';

// Validate the user's level of access for this form.
$GLOBALS["form"] = 'subcontent';
$GLOBALS["validaccess"] = VerifyAdminLogin();
$GLOBALS["specialedit"] = True;


//	Set list of textareas in an array for HTMLArea integration
$GLOBALS["textareas"]	= array('descr');
$GLOBALS["base_url"] = SiteBaseUrl($EZ_SESSION_VARS["Site"]);



GetModuleData($GLOBALS["ModuleRef"]);

// If we've been passed the request from the banner list, then we
//    read banner data from the database for an edit request, or skip
//    if this is an 'add new' request
if ($HTTP_GET_VARS["LinkID"] != "") {
   $HTTP_POST_VARS["LinkID"] = $HTTP_GET_VARS["LinkID"];
   $HTTP_POST_VARS["page"] = $HTTP_GET_VARS["page"];
   GetGlobalData();
} else {
   $timenow = time();			// Calculate the default expiry date
   $GLOBALS["DefExpDate"] = DateAdd($expiryperiod,$expirynumber,$timenow);
   GetFormData;
}

if ($HTTP_POST_VARS["submitted"] == "yes") {
   AddLinks();
   Header("Location: ".BuildLink('m_'.$GLOBALS["ModuleName"].'.php')."&page=".$HTTP_POST_VARS["page"]);
}

frmLinksForm();


function frmLinksForm()
{
   global $EZ_SESSION_VARS, $HTTP_POST_VARS;

   adminformheader();
   adminformopen('PublishDay');
   adminformtitle(2,$GLOBALS["tFormTitle"]);

   if ($GLOBALS["scUseCategories"] == 'Y') {
      ?>
      <tr class="tablecontent">
          <?php FieldHeading("Category","catcode"); ?>
          <td valign="top" class="content">
              <select name="catcode" size="1">
                  <option value="0">
                  <?php RenderAllCategories($GLOBALS["gsCatCode"]); ?>
              </select>
          </td>
      </tr>
      <?php
   } else {
      ?><input type="hidden" name="catcode" value="0"><?php
   }
   ?>
   <tr class="tablecontent">
       <?php FieldHeading("PublishDate","PublishDay"); ?>
       <td valign="top" class="content">
			<?php admindatedisplay('Publish',$GLOBALS["gsPublishDate"]); ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("WebURL","webURL"); ?>
       <td valign="top" class="content">
           <input type="text" name="webURL" size="50" value="<?php echo htmlspecialchars($GLOBALS["gsWeb_Page"]); ?>" maxlength=255<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("Description","descr"); ?>
       <td valign="top" class="content">
			<?php
			if ((isset($GLOBALS["textareas"])) && ($EZ_SESSION_VARS["WYSIWYG"] == 'Y')) {
				?>
				<textarea id="descr" name="descr" style="width:540; height:240"<?php echo $GLOBALS["fieldstatus"]; ?>><?php echo $GLOBALS["gsDescr"]; ?></textarea>
				<?php
			} else {
	           EditButtons("Description","descr");
				?>
				<textarea rows="6" id="descr" name="descr" cols="64"<?php echo $GLOBALS["fieldstatus"]; ?>><?php echo htmlspecialchars($GLOBALS["gsDescr"]); ?></textarea>
				<?php
			}
			admintagdisplay('descr');
			admintagdisplay2('descr');
			?>
       </td>
   </tr>
   <?php
   adminformsavebar(2,'m_links.php');
   if ($GLOBALS["specialedit"] == True) {
//      adminhelpmsg(2);
      ?><input type="hidden" name="LinkID" value="<?php echo $HTTP_POST_VARS["LinkID"]; ?>"><?php
   }
   adminformclose();
} // function frmLinksForm()


function AddLinks()
{
   global $HTTP_POST_VARS, $EZ_SESSION_VARS;

   $publishisodate = dbDateTime(sprintf("%04d-%02d-%02d 00:00:00", $HTTP_POST_VARS["PublishYear"], $HTTP_POST_VARS["PublishMonth"], $HTTP_POST_VARS["PublishDay"]));
   $updateisodate  = dbDateTime(sprintf("%04d-%02d-%02d %02d:%02d:%02d", strftime("%Y"), strftime("%m"), strftime("%d"), strftime("%H"), strftime("%M"), strftime("%S")));
   $authorid = lGetAuthorID();

   $sWebURL  = trim($HTTP_POST_VARS["webURL"]);
   $sDescr = trim(dbString($HTTP_POST_VARS["descr"]));
	if ($sDescr == '<br />') { $sDescr = '';
	} else {
		//	Adjust any absolute URLs to relative URLs for images and downloads
		$sDescr = str_replace($GLOBALS["tqBlock1"].'./',$GLOBALS["tqBlock1"].'/',$sDescr);
		$sDescr = str_replace($GLOBALS["base_url"],'./',$sDescr); 
		$sDescr = str_replace('<./','</',$sDescr);
		//	Compile pre-compiled tags
		$sDescr = trim(compile($GLOBALS["tqBlock1"].'html'.$GLOBALS["tqBlock2"].$sDescr.$GLOBALS["tqBlock1"].$GLOBALS["tqCloseBlock"].'html'.$GLOBALS["tqBlock2"], $EZ_SESSION_VARS["WYSIWYG"], $GLOBALS["RestrictTags"]));
	}

   if ($GLOBALS["scValidate"] == 'Y') { $scValid = 0; }
   else { $scValid = 1; }

   if ($HTTP_POST_VARS["LinkID"] != "") {
      $strQuery = "UPDATE ".$GLOBALS["scTable"]." SET linkurl='".$sWebURL."', publishdate='".$publishisodate."', linkdescr='".$sDescr."', updatedate='".$updateisodate."', authorid='".$authorid."', catid='".$HTTP_POST_VARS["catcode"]."' WHERE linksid='".$HTTP_POST_VARS["LinkID"]."'";
   } else {
      $strQuery = "INSERT INTO ".$GLOBALS["scTable"]." VALUES('', '".$publishisodate."', '".$sWebURL."', '".$sDescr."', '".$scValid."', '".$authorid."', '".$updateisodate."', '".$HTTP_POST_VARS["catcode"]."')";
   }
   $result = dbExecute($strQuery,true);
   dbCommit();
}


function GetGlobalData()
{
   global $EZ_SESSION_VARS, $HTTP_GET_VARS, $HTTP_POST_VARS;

   $strQuery="SELECT * FROM ".$GLOBALS["scTable"]." WHERE linksid='".$HTTP_GET_VARS["LinkID"]."'";
   $result = dbRetrieve($strQuery,true,0,0);
   $rs     = dbFetch($result);

   $GLOBALS["gsWeb_Page"]		= $rs["linkurl"];
   $GLOBALS["gsPublishDate"]	= $rs["publishdate"];
   $GLOBALS["gsCatCode"]		= $rs["catid"];

	if ($EZ_SESSION_VARS["WYSIWYG"] == 'Y') {
		$GLOBALS["gsDescr"]	= formatWYSIWYG($rs["linkdescr"]);
	} else {
		$GLOBALS["gsDescr"]	= $rs["linkdescr"];
	}

   $HTTP_POST_VARS["authorid"] = $rs["authorid"];
   if ($rs["authorid"] == $EZ_SESSION_VARS["UserID"]) {
      $GLOBALS["specialedit"] = True;
      $GLOBALS["fieldstatus"] = '';
   }
} // function GetGlobalData()


function GetFormData()
{
   global $EZ_SESSION_VARS, $HTTP_POST_VARS;

   $publishisodate = sprintf("%04d-%02d-%02d", $HTTP_POST_VARS["PublishYear"], $HTTP_POST_VARS["PublishMonth"], $HTTP_POST_VARS["PublishDay"]);
   $expireisodate = sprintf("%04d-%02d-%02d", $HTTP_POST_VARS["ExpireYear"], $HTTP_POST_VARS["ExpireMonth"], $HTTP_POST_VARS["ExpireDay"]);

   $GLOBALS["gsPublishDate"]	= $publishisodate;
   $GLOBALS["gsWeb_Page"]		= $HTTP_POST_VARS["webURL"];
   $GLOBALS["gsDescr"]			= $HTTP_POST_VARS["descr"];
   $GLOBALS["gsCatCode"]		= $HTTP_POST_VARS["catcode"];

   if ($HTTP_POST_VARS["authorid"] == $EZ_SESSION_VARS["UserID"]) {
      $GLOBALS["specialedit"] = True;
      $GLOBALS["fieldstatus"] = '';
   }
} // function GetFormData()

ModuleJavaFunctions();

?>
