# --------------------------------------------------------
#
# Table structure for table `news`
#

DROP TABLE IF EXISTS news;
CREATE TABLE news (
  newsid int(11) unsigned NOT NULL auto_increment,
  title varchar(255) default NULL,
  publishdate datetime default NULL,
  expiredate datetime default NULL,
  contactname varchar(255) default NULL,
  contactemail varchar(255) default NULL,
  web_page varchar(255) default NULL,
  teaser text,
  body text,
  activeentry char(1) default NULL,
  authorid int(11) default NULL,
  updatedate datetime default NULL,
  catid varchar(16) default NULL,
  PRIMARY KEY  (newsid)
) TYPE=MyISAM;


# --------------------------------------------------------
#
# Table structure for table `newscategories`
#

DROP TABLE IF EXISTS newscategories;
CREATE TABLE newscategories (
  catid int(11) unsigned NOT NULL auto_increment,
  catname varchar(32) NOT NULL default '',
  catref varchar(32) default NULL,
  hiddencat char(1) default '0',
  PRIMARY KEY  (catid)
) TYPE=MyISAM;


# --------------------------------------------------------
#
# Data for table `modules`
#
INSERT INTO modules (modulename, extin, moduledirectory, modulescript, modulesubmit) VALUES ('News', 'E', 'news', 'shownews.php', 'Y');
INSERT INTO modules (modulename, extin, moduledirectory, modulescript, modulesubmit) VALUES ('Archived News', 'E', 'news', 'archivednews.php', 'N');
INSERT INTO modules (modulename, extin, moduledirectory, modulescript, modulesubmit) VALUES ('Inline News', 'I', 'news', 'inlinenews.php', 'N');


# --------------------------------------------------------
#
# Data for table `modulesettings`
#
INSERT INTO modulesettings (modulename, settingname, settingvalue) VALUES ('news', 'version', '2.0.0');
INSERT INTO modulesettings (modulename, settingname, settingvalue) VALUES ('news', 'author', 'The ezContents Development Team');


# --------------------------------------------------------
#
# Data for table `specialcontents`
#
INSERT INTO specialcontents (scname, sctitle, scdb, screg, scvalid, stextdisplay, stext, sgraphicdisplay, sgraphic, usergroups, scuseprefix, scusecategories, orderby, showpostedby, showposteddate, perpage) VALUES ('news', 'This week\'s breaking news stories', 'news', 'Y', 'Y', 'Y', 'Submit News Story', '', '', '', 'N', 'N', 'C', '', 'Y', 5);
