<?php

/***************************************************************************

 m_news.php
 -----------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

$GLOBALS["ModuleName"] = 'news';
include("moduleref.php");

$GLOBALS["rootdp"] = '../../';
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");

$GLOBALS["form"] = 'subcontent';
$GLOBALS["validaccess"] = VerifyAdminLogin();


include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ($GLOBALS["rootdp"].$GLOBALS["language_home"].$GLOBALS["gsLanguage"]."/lang_admin.php");
include_languagefile ($GLOBALS["modules_home"].$GLOBALS["ModuleRef"].'/',$GLOBALS["gsLanguage"],'lang_news.php');
include ($GLOBALS["rootdp"].$GLOBALS["admin_home"]."adminfunctions.php");
include ($GLOBALS["rootdp"].$GLOBALS["admin_home"]."adminbutton.php");
include ($GLOBALS["rootdp"].$GLOBALS["modules_home"]."modfunctions.php");


GetSpecialData($GLOBALS["ModuleRef"]);

frmNews();


function frmNews()
{
   global $HTTP_GET_VARS;

   adminheader();
   admintitle(6,$GLOBALS["tFormTitle"]);

   // Generate image tags for the different images that appear on the page
   adminbuttons($GLOBALS["tViewNews"],$GLOBALS["tAddNewNews"],$GLOBALS["tEditNews"],$GLOBALS["tDeleteNews"]);
   $GLOBALS["iRelease"] = lsimagehtmltag($GLOBALS["icon_home"],'rel_button.gif',$GLOBALS["gsLanguage"],$GLOBALS["tReleaseNews"],0);

   $strQuery = "SELECT newsid FROM ".$GLOBALS["scTable"];
   $result = dbRetrieve($strQuery,true,0,0);
   $lRecCount = dbRowsReturned($result);
   dbFreeResult($result);

   $nCurrentPage = 0;
   if ($HTTP_GET_VARS["sort"] == '') { $HTTP_GET_VARS["sort"] = 5; }
   if ($HTTP_GET_VARS["page"] != "") { $nCurrentPage = $HTTP_GET_VARS["page"]; }
   $nPages = intval(($lRecCount - 0.5) / $GLOBALS["RECORDS_PER_PAGE"]) + 1;
   $lStartRec = $nCurrentPage * $GLOBALS["RECORDS_PER_PAGE"];

   frmModuleHdFt(6,$nCurrentPage,$nPages);
   ?>
   <tr class="teaserheadercontent">
   <?php
       adminlistitem(12,$GLOBALS["tEditDelRel"],'');
       adminlistitem(32,$GLOBALS["tHeadline"],'',1);
       adminlistitem(19,$GLOBALS["tPostedBy"],'',2);
       adminlistitem(12,$GLOBALS["tPublishDate"],'',3);
       adminlistitem(12,$GLOBALS["tExpiryDate"],'',4);
       adminlistitem(8,$GLOBALS["tStatus"],'',5);
	?>
	</tr>
	<?php

	switch ($HTTP_GET_VARS["sort"]) {
		case '1' : $sort = 'title,publishdate DESC';
				   break;
		case '2' : $sort = 'authorid,publishdate DESC';
				   break;
		case '3' : $sort = 'publishdate DESC';
				   break;
		case '4' : $sort = 'expiredate DESC';
				   break;
		case '5' : $sort = 'activeentry,publishdate DESC,expiredate';
				   break;
		default  : $sort = 'activeentry,publishdate DESC,expiredate';
	}
	$strQuery = "SELECT * FROM ".$GLOBALS["scTable"]." ORDER BY ".$sort;
	$result = dbRetrieve($strQuery,true,$lStartRec,$GLOBALS["RECORDS_PER_PAGE"]);
	while ($rsNews = dbFetch($result)) {
		?>
		<tr class="teasercontent">
			<td align="center" valign="top" class="content">
				<?php admineditcheck('newsform','NewsID',$rsNews["newsid"],$rsNews["authorid"]); ?>
				<?php admindeletecheck('DelEntry','NewsID',$rsNews["newsid"]); ?>&nbsp;
				<?php adminreleasecheck('RelEntry','NewsID',$rsNews["newsid"]); ?>&nbsp;
			</td>
			<td valign="top" class="content"><?php echo $rsNews["title"]; ?></td>
			<td valign="top" class="content"><?php echo lGetAuthorName($rsNews["authorid"]); ?></td>
			<td valign="top" class="content"><?php echo substr($rsNews["publishdate"], 0, 10); ?></td>
			<td valign="top" class="content"><?php echo substr($rsNews["expiredate"], 0, 10); ?></td>
			<td valign="top" class="content"><?php if ($rsNews["activeentry"] == 1) { echo $GLOBALS["tReleased"]; } else { echo $GLOBALS["tPending"]; } ?></td>
		</tr>
		<?php
	}

	dbFreeResult($result);

	frmModuleHdFt(6,$nCurrentPage,$nPages);
	frmModuleReturn(6);
	?>
	</table>
	</form>
	</body>
	</html>
	<?php
}

frmModuleJs();

?>
