<?php

/***************************************************************************

 m_newsform.php
 ---------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

// Localisation variables (used for default values)
// Change these to suit your site preferences
//
$expiryperiod = 'm';			// Time period to calculate the banner expiry date (based on today's date)
$expirynumber = 1;


$GLOBALS["ModuleName"] = 'news';
include("moduleref.php");


$GLOBALS["rootdp"] = '../../';
include_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");

include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ($GLOBALS["rootdp"].$GLOBALS["admin_home"]."adminfunctions.php");
include ($GLOBALS["rootdp"].$GLOBALS["admin_home"]."compile.php");
include ($GLOBALS["rootdp"].$GLOBALS["modules_home"]."modfunctions.php");
include ($GLOBALS["rootdp"].$GLOBALS["language_home"].$GLOBALS["gsLanguage"]."/lang_admin.php");
include ($GLOBALS["rootdp"].$GLOBALS["language_home"].$GLOBALS["gsLanguage"]."/lang_main.php");
include_languagefile ($GLOBALS["modules_home"].$GLOBALS["ModuleRef"].'/',$GLOBALS["gsLanguage"],'lang_news.php');


// Security vet.
// Start by setting all security access to false.
// Do it in the code to overwrite any spurious values that a hacker may
//    have tried to pass in the url
$GLOBALS["specialedit"] = $GLOBALS["canedit"] = $GLOBALS["canadd"] = $GLOBALS["canview"] = False;
$GLOBALS["fieldstatus"] = '';

// Validate the user's level of access for this form.
$GLOBALS["form"] = 'subcontent';
$GLOBALS["validaccess"] = VerifyAdminLogin();
$GLOBALS["specialedit"] = True;


//	Set list of textareas in an array for HTMLArea integration
$GLOBALS["textareas"]	= array('teaser','body');
$GLOBALS["base_url"] = SiteBaseUrl($EZ_SESSION_VARS["Site"]);



GetModuleData($GLOBALS["ModuleRef"]);

// If we've been passed the request from the banner list, then we
//    read banner data from the database for an edit request, or skip
//    if this is an 'add new' request
if ($HTTP_GET_VARS["NewsID"] != "") {
   $HTTP_POST_VARS["NewsID"] = $HTTP_GET_VARS["NewsID"];
   $HTTP_POST_VARS["page"] = $HTTP_GET_VARS["page"];
   GetGlobalData();
} else {
   $timenow = time();			// Calculate the default expiry date
   $GLOBALS["DefExpDate"] = date('Y-m-d H:i:s',DateAdd($expiryperiod,$expirynumber,$timenow));
   GetFormData;
}

if ($HTTP_POST_VARS["submitted"] == "yes") {
   AddNews();
   Header("Location: ".BuildLink('m_'.$GLOBALS["ModuleName"].'.php')."&page=".$HTTP_POST_VARS["page"]);
}

frmNewsForm();


function frmNewsForm()
{
   global $EZ_SESSION_VARS, $HTTP_POST_VARS;

   adminformheader();
   adminformopen('PublishDay');
   adminformtitle(2,$GLOBALS["tFormTitle"]);

   if ($GLOBALS["scUseCategories"] == 'Y') {
      ?>
      <tr class="tablecontent">
          <?php FieldHeading("Category","catcode"); ?>
          <td valign="top" class="content">
              <select name="catcode" size="1">
                  <option value="0">
                  <?php RenderAllCategories($GLOBALS["gsCatCode"]); ?>
              </select>
          </td>
      </tr>
      <?php
   } else {
      ?><input type="hidden" name="catcode" value="0"><?php
   }
   ?>
   <tr class="tablecontent">
       <?php FieldHeading("PublishDate","PublishDay"); ?>
       <td valign="top" class="content">
			<?php admindatedisplay('Publish',$GLOBALS["gsPublishDate"]); ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("ExpiryDate","ExpiryDay"); ?>
       <td valign="top" class="content">
			<?php admindatedisplay('Expire',$GLOBALS["gsExpireDate"],$GLOBALS["DefExpDate"]); ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("Headline","title"); ?>
       <td valign="top" class="content">
           <input type="text" name="title" size="50" value="<?php echo htmlspecialchars($GLOBALS["gsTitle"]) ?>" maxlength=255<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("Summary","teaser"); ?>
       <td valign="top" class="content">
			<?php
			if ((isset($GLOBALS["textareas"])) && ($EZ_SESSION_VARS["WYSIWYG"] == 'Y')) {
				?>
				<textarea id="teaser" name="teaser" style="width:540; height:240"<?php echo $GLOBALS["fieldstatus"]; ?>><?php echo $GLOBALS["gsTeaser"]; ?></textarea>
				<?php
			} else {
	           EditButtons("Summary","teaser");
				?>
				<textarea rows="6" id="teaser" name="teaser" cols="64"<?php echo $GLOBALS["fieldstatus"]; ?>><?php echo htmlspecialchars($GLOBALS["gsTeaser"]); ?></textarea>
				<?php
			}
			admintagdisplay('teaser');
			admintagdisplay2('teaser');
			?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("Details","body"); ?>
       <td valign="top" class="content">
			<?php
			if ((isset($GLOBALS["textareas"])) && ($EZ_SESSION_VARS["WYSIWYG"] == 'Y')) {
				?>
				<textarea id="body" name="body" style="width:540; height:240"<?php echo $GLOBALS["fieldstatus"]; ?>><?php echo $GLOBALS["gsBody"]; ?></textarea>
				<?php
			} else {
	           EditButtons("Details","body");
				?>
				<textarea rows="6" id="body" name="body" cols="64"<?php echo $GLOBALS["fieldstatus"]; ?>><?php echo htmlspecialchars($GLOBALS["gsBody"]); ?></textarea>
				<?php
			}
			admintagdisplay('body');
			admintagdisplay2('body');
			?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("CName","contactname"); ?>
       <td valign="top" class="content">
           <input type="text" name="contactname" size="50" value="<?php echo htmlspecialchars($GLOBALS["gsContactName"]) ?>" maxlength=255<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("CEMail","contactemail"); ?>
       <td valign="top" class="content">
           <input type="text" name="contactemail" size="60" value="<?php echo htmlspecialchars($GLOBALS["gsContactEmail"]) ?>" maxlength=255<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("WebRef","web_page"); ?>
       <td valign="top" class="content">
           <input type="text" name="web_page" size="70" value="<?php echo htmlspecialchars($GLOBALS["gsWeb_Page"]) ?>" maxlength=255<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <?php
   adminformsavebar(2,'m_news.php');
   if ($GLOBALS["specialedit"] == True) {
//      adminhelpmsg(2);
      ?><input type="hidden" name="NewsID" value="<?php echo $HTTP_POST_VARS["NewsID"]; ?>"><?php
   }
   adminformclose();
} // function frmNewsForm()


function AddNews()
{
   global $HTTP_POST_VARS, $EZ_SESSION_VARS;

   $publishisodate = dbDateTime(sprintf("%04d-%02d-%02d 00:00:00", $HTTP_POST_VARS["PublishYear"], $HTTP_POST_VARS["PublishMonth"], $HTTP_POST_VARS["PublishDay"]));
   $expireisodate  = dbDateTime(sprintf("%04d-%02d-%02d 00:00:00", $HTTP_POST_VARS["ExpireYear"], $HTTP_POST_VARS["ExpireMonth"], $HTTP_POST_VARS["ExpireDay"]));
   $updateisodate  = dbDateTime(sprintf("%04d-%02d-%02d %02d:%02d:%02d", strftime("%Y"), strftime("%m"), strftime("%d"), strftime("%H"), strftime("%M"), strftime("%S")));
   $authorid = lGetAuthorID();

   $sTitle  = trim(dbString($HTTP_POST_VARS["title"]));
   $sTeaser = trim(dbString($HTTP_POST_VARS["teaser"]));
	if ($sTeaser == '<br />') { $sTeaser = '';
	} else {
		//	Adjust any absolute URLs to relative URLs for images and downloads
		$sTeaser = str_replace($GLOBALS["tqBlock1"].'./',$GLOBALS["tqBlock1"].'/',$sTeaser);
		$sTeaser = str_replace($GLOBALS["base_url"],'./',$sTeaser); 
		$sTeaser = str_replace('<./','</',$sTeaser);
		//	Compile pre-compiled tags
		$sTeaser = trim(compile($GLOBALS["tqBlock1"].'html'.$GLOBALS["tqBlock2"].$sTeaser.$GLOBALS["tqBlock1"].$GLOBALS["tqCloseBlock"].'html'.$GLOBALS["tqBlock2"], $EZ_SESSION_VARS["WYSIWYG"], $GLOBALS["RestrictTags"]));
	}
   $sBody   = trim(dbString($HTTP_POST_VARS["body"]));
	if ($sBody == '<br />') { $sBody = '';
	} else {
		//	Adjust any absolute URLs to relative URLs for images and downloads
		$sBody	= str_replace($GLOBALS["tqBlock1"].'./',$GLOBALS["tqBlock1"].'/',$sBody);
		$sBody	= str_replace($GLOBALS["base_url"],'./',$sBody);
		$sBody	= str_replace('<./','</',$sBody);
		//	Compile pre-compiled tags
		$sBody	= trim(compile($GLOBALS["tqBlock1"].'html'.$GLOBALS["tqBlock2"].$sBody.$GLOBALS["tqBlock1"].$GLOBALS["tqCloseBlock"].'html'.$GLOBALS["tqBlock2"], $EZ_SESSION_VARS["WYSIWYG"], $GLOBALS["RestrictTags"]));
	}

   if ($GLOBALS["scValidate"] == 'Y') { $scValid = 0; }
   else { $scValid = 1; }

   if ($HTTP_POST_VARS["NewsID"] != "") {
      $strQuery = "UPDATE ".$GLOBALS["scTable"]." SET title='".$sTitle."', publishdate='".$publishisodate."', expiredate='".$expireisodate."', contactname='".$HTTP_POST_VARS["contactname"]."', contactemail='".$HTTP_POST_VARS["contactemail"]."', web_page='".$HTTP_POST_VARS["web_page"]."', body='".$sBody."', teaser='".$sTeaser."', updatedate='".$updateisodate."', authorid='".$authorid."', catid='".$HTTP_POST_VARS["catcode"]."' WHERE newsid='".$HTTP_POST_VARS["NewsID"]."'";
   } else {
      $strQuery = "INSERT INTO ".$GLOBALS["scTable"]." VALUES('', '".$sTitle."', '".$publishisodate."', '".$expireisodate."', '".$HTTP_POST_VARS["contactname"]."', '".$HTTP_POST_VARS["contactemail"]."', '".$HTTP_POST_VARS["web_page"]."', '".$sTeaser."', '".$sBody."', '".$scValid."', '".$authorid."', '".$updateisodate."', '".$HTTP_POST_VARS["catcode"]."')";
   }
   $result = dbExecute($strQuery,true);
   dbCommit();
}


function GetGlobalData()
{
   global $EZ_SESSION_VARS, $HTTP_GET_VARS, $HTTP_POST_VARS;

   $strQuery="SELECT * FROM ".$GLOBALS["scTable"]." WHERE newsid='".$HTTP_GET_VARS["NewsID"]."'";
   $result = dbRetrieve($strQuery,true,0,0);
   $rs     = dbFetch($result);

   $GLOBALS["gsTitle"]          = $rs["title"];
   $GLOBALS["gsPublishDate"]    = $rs["publishdate"];
   $GLOBALS["gsExpireDate"]     = $rs["expiredate"];
   $GLOBALS["gsContactName"]    = $rs["contactname"];
   $GLOBALS["gsContactEmail"]   = $rs["contactemail"];
   $GLOBALS["gsWeb_Page"]       = $rs["web_page"];
   $GLOBALS["gsCatCode"]        = $rs["catid"];

	if ($EZ_SESSION_VARS["WYSIWYG"] == 'Y') {
		$GLOBALS["gsBody"]			= formatWYSIWYG($rs["body"]);
		$GLOBALS["gsTeaser"]		= formatWYSIWYG($rs["teaser"]);
	} else {
		$GLOBALS["gsTeaser"]		= $rs["teaser"];
		$GLOBALS["gsBody"]			= $rs["body"];
	}

   $HTTP_POST_VARS["authorid"] = $rs["authorid"];
   if ($rs["authorid"] == $EZ_SESSION_VARS["UserID"]) {
      $GLOBALS["specialedit"] = True;
      $GLOBALS["fieldstatus"] = '';
   }
} // function GetGlobalData()


function GetFormData()
{
   global $EZ_SESSION_VARS, $HTTP_POST_VARS;

   $publishisodate = sprintf("%04d-%02d-%02d", $HTTP_POST_VARS["PublishYear"], $HTTP_POST_VARS["PublishMonth"], $HTTP_POST_VARS["PublishDay"]);
   $expireisodate = sprintf("%04d-%02d-%02d", $HTTP_POST_VARS["ExpireYear"], $HTTP_POST_VARS["ExpireMonth"], $HTTP_POST_VARS["ExpireDay"]);

   $GLOBALS["gsTitle"]          = $HTTP_POST_VARS["title"];
   $GLOBALS["gsPublishDate"]    = $publishisodate;
   $GLOBALS["gsExpireDate"]     = $expireisodate;
   $GLOBALS["gsContactName"]    = $HTTP_POST_VARS["contactname"];
   $GLOBALS["gsContactEmail"]   = $HTTP_POST_VARS["contactemail"];
   $GLOBALS["gsWeb_Page"]       = $HTTP_POST_VARS["web_page"];
   $GLOBALS["gsBody"]           = $HTTP_POST_VARS["body"];
   $GLOBALS["gsTeaser"]         = $HTTP_POST_VARS["teaser"];
   $GLOBALS["gsCatCode"]        = $HTTP_POST_VARS["catcode"];

   if ($HTTP_POST_VARS["authorid"] == $EZ_SESSION_VARS["UserID"]) {
      $GLOBALS["specialedit"] = True;
      $GLOBALS["fieldstatus"] = '';
   }
} // function GetFormData()

ModuleJavaFunctions();

?>
