# --------------------------------------------------------
#
# Table structure for table `reviews`
#

DROP TABLE IF EXISTS reviews;
CREATE TABLE reviews (
  reviewsid int(11) unsigned NOT NULL auto_increment,
  title varchar(255) default NULL,
  author varchar(255) default NULL,
  publisher varchar(255) default NULL,
  publishdate datetime default NULL,
  contactname varchar(255) default NULL,
  contactemail varchar(255) default NULL,
  web_page varchar(255) default NULL,
  teaser text,
  body text,
  rating int(2) NOT NULL default '99',
  activeentry char(1) default NULL,
  authorid int(11) default NULL,
  updatedate datetime default NULL,
  catid varchar(16) default NULL,
  PRIMARY KEY  (reviewsid)
) TYPE=MyISAM;


# --------------------------------------------------------
#
# Table structure for table `reviewscategories`
#

DROP TABLE IF EXISTS reviewscategories;
CREATE TABLE reviewscategories (
  catid int(11) unsigned NOT NULL auto_increment,
  catname varchar(32) NOT NULL default '',
  catref varchar(32) default NULL,
  hiddencat char(1) default '0',
  PRIMARY KEY  (catid)
) TYPE=MyISAM;


# --------------------------------------------------------
#
# Data for table `modules`
#
INSERT INTO modules (modulename, extin, moduledirectory, modulescript, modulesubmit) VALUES ('Reviews', 'E', 'reviews', 'showreviews.php', 'Y');


# --------------------------------------------------------
#
# Data for table `modulesettings`
#
INSERT INTO modulesettings (modulename, settingname, settingvalue) VALUES ('reviews', 'version', '2.0.0');
INSERT INTO modulesettings (modulename, settingname, settingvalue) VALUES ('reviews', 'author', 'The ezContents Development Team');


# --------------------------------------------------------
#
# Data for table `specialcontents`
#
INSERT INTO specialcontents (scname, sctitle, scdb, screg, scvalid, stextdisplay, stext, sgraphicdisplay, sgraphic, usergroups, scuseprefix, scusecategories, orderby, showpostedby, showposteddate, perpage) VALUES ('reviews', 'Book, Film and Game Reviews', 'reviews', 'Y', 'Y', 'Y', 'Submit Review', '', '', '', 'N', 'N', 'C', '', 'Y', 8);
