<?php

/***************************************************************************

 m_reviewsform.php
 ------------------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

// Localisation variables (used for default values)
// Change these to suit your site preferences
//
$expiryperiod = 'm';			// Time period to calculate the banner expiry date (based on today's date)
$expirynumber = 1;


$GLOBALS["ModuleName"] = 'reviews';
include("moduleref.php");

$GLOBALS["rootdp"] = '../../';
require_once ($GLOBALS["rootdp"]."include/config.php");
require_once ($GLOBALS["rootdp"]."include/db.php");
require_once ($GLOBALS["rootdp"]."include/session.php");

include ($GLOBALS["rootdp"]."include/access.php");

include ($GLOBALS["rootdp"]."include/settings.php");
include ($GLOBALS["rootdp"]."include/functions.php");
include ($GLOBALS["rootdp"].$GLOBALS["admin_home"]."adminfunctions.php");
include ($GLOBALS["rootdp"].$GLOBALS["modules_home"]."modfunctions.php");
include ($GLOBALS["rootdp"].$GLOBALS["language_home"].$GLOBALS["gsLanguage"]."/lang_admin.php");
include ($GLOBALS["rootdp"].$GLOBALS["language_home"].$GLOBALS["gsLanguage"]."/lang_main.php");
include_languagefile ($GLOBALS["modules_home"].$GLOBALS["ModuleRef"].'/',$GLOBALS["gsLanguage"],'lang_reviews.php');


// Security vet.
// Start by setting all security access to false.
// Do it in the code to overwrite any spurious values that a hacker may
//    have tried to pass in the url
$GLOBALS["specialedit"] = $GLOBALS["canedit"] = $GLOBALS["canadd"] = $GLOBALS["canview"] = False;
$GLOBALS["fieldstatus"] = '';

// Validate the user's level of access for this form.
$GLOBALS["form"] = 'subcontent';
$GLOBALS["validaccess"] = VerifyAdminLogin();
$GLOBALS["specialedit"] = True;


GetModuleData($GLOBALS["ModuleRef"]);

// If we've been passed the request from the banner list, then we
//    read banner data from the database for an edit request, or skip
//    if this is an 'add new' request
if ($HTTP_GET_VARS["reviewsID"] != "") {
   $HTTP_POST_VARS["reviewsID"] = $HTTP_GET_VARS["reviewsID"];
   $HTTP_POST_VARS["page"] = $HTTP_GET_VARS["page"];
   GetGlobalData();
} else {
   $timenow = time();			// Calculate the default expiry date
   $GLOBALS["DefExpDate"] = date('Y-m-d H:i:s',DateAdd($expiryperiod,$expirynumber,$timenow));
   GetFormData;
}

if ($HTTP_POST_VARS["submitted"] == "yes") {
   Addreviews();
   Header("Location: ".BuildLink('m_'.$GLOBALS["ModuleName"].'.php')."&page=".$HTTP_POST_VARS["page"]);
}

frmreviewsForm();


function frmreviewsForm()
{
   global $HTTP_POST_VARS;

   adminformheader();
   adminformopen('PublishDay');
   adminformtitle(2,$GLOBALS["tFormTitle"]);

   if ($GLOBALS["scUseCategories"] == 'Y') {
      ?>
      <tr class="tablecontent">
          <?php FieldHeading("Category","catcode"); ?>
          <td valign="top" class="content">
              <select name="catcode" size="1">
                  <option value="0">
                  <?php RenderAllCategories($GLOBALS["gsCatCode"]); ?>
              </select>
          </td>
      </tr>
      <?php
   } else {
      ?><input type="hidden" name="catcode" value="0"><?php
   }
   ?>
   <tr class="tablecontent">
       <?php FieldHeading("PublishDate","PublishDay"); ?>
       <td valign="top" class="content">
			<?php admindatedisplay('Publish',$GLOBALS["gsPublishDate"]); ?>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("Title","title"); ?>
       <td valign="top" class="content">
           <input type="text" name="title" size="50" value="<?php echo htmlspecialchars($GLOBALS["gsTitle"]) ?>" maxlength=255<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("Author","author"); ?>
       <td valign="top" class="content">
           <input type="text" name="author" size="50" value="<?php echo htmlspecialchars($GLOBALS["gsAuthor"]) ?>" maxlength=255<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("Publisher","publisher"); ?>
       <td valign="top" class="content">
           <input type="text" name="publisher" size="50" value="<?php echo htmlspecialchars($GLOBALS["gsPublisher"]) ?>" maxlength=255<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("Summary","teaser"); ?>
       <td valign="top" class="content">
           <?php EditButtons("Summary","teaser"); ?>
           <textarea rows="8" name="teaser" cols="66"<?php echo $GLOBALS["fieldstatus"]; ?>><?php echo htmlspecialchars($GLOBALS["gsTeaser"]); ?></textarea>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("Details","body"); ?>
       <td valign="top" class="content">
           <?php EditButtons("Details","body"); ?>
           <textarea rows="8" name="body" cols="66"<?php echo $GLOBALS["fieldstatus"]; ?>><?php echo htmlspecialchars($GLOBALS["gsBody"]); ?></textarea>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("Rating","rating"); ?>
       <td valign="top" class="content">
           <select name="rating" size="1">
               <?php RenderRatings($GLOBALS["gsRating"]); ?>
           </select>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("CName","contactname"); ?>
       <td valign="top" class="content">
           <input type="text" name="contactname" size="50" value="<?php echo htmlspecialchars($GLOBALS["gsContactName"]) ?>" maxlength=255<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("CEMail","contactemail"); ?>
       <td valign="top" class="content">
           <input type="text" name="contactemail" size="60" value="<?php echo htmlspecialchars($GLOBALS["gsContactEmail"]) ?>" maxlength=255<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <tr class="tablecontent">
       <?php FieldHeading("WebRef","web_page"); ?>
       <td valign="top" class="content">
           <input type="text" name="web_page" size="70" value="<?php echo htmlspecialchars($GLOBALS["gsWeb_Page"]) ?>" maxlength=255<?php echo $GLOBALS["fieldstatus"]; ?>>
       </td>
   </tr>
   <?php
   adminformsavebar(2,'m_reviews.php');
   if ($GLOBALS["specialedit"] == True) {
//      adminhelpmsg(2);
      ?><input type="hidden" name="reviewsID" value="<?php echo $HTTP_POST_VARS["reviewsID"]; ?>"><?php
   }
   adminformclose();
} // function frmreviewsForm()


function Addreviews()
{
   global $HTTP_POST_VARS;

   $publishisodate = dbDateTime(sprintf("%04d-%02d-%02d 00:00:00", $HTTP_POST_VARS["PublishYear"], $HTTP_POST_VARS["PublishMonth"], $HTTP_POST_VARS["PublishDay"]));
   $updateisodate  = dbDateTime(sprintf("%04d-%02d-%02d %02d:%02d:%02d", strftime("%Y"), strftime("%m"), strftime("%d"), strftime("%H"), strftime("%M"), strftime("%S")));
   $authorid = lGetAuthorID();

   $sTitle     = dbString($HTTP_POST_VARS["title"]);
   $sAuthor    = dbString($HTTP_POST_VARS["author"]);
   $sPublisher = dbString($HTTP_POST_VARS["publisher"]);
   $sTeaser    = dbString($HTTP_POST_VARS["teaser"]);
   $sBody      = dbString($HTTP_POST_VARS["body"]);

   if ($GLOBALS["scValidate"] == 'Y') { $scValid = 0;
   } else { $scValid = 1; }

   if ($HTTP_POST_VARS["reviewsID"] != "") {
      $strQuery = "UPDATE ".$GLOBALS["scTable"]." SET title='".$sTitle."', author='".$sAuthor."', publisher='".$sPublisher."', publishdate='".$publishisodate."', contactname='".$HTTP_POST_VARS["contactname"]."', contactemail='".$HTTP_POST_VARS["contactemail"]."', web_page='".$HTTP_POST_VARS["web_page"]."', body='".$sBody."', teaser='".$sTeaser."', rating='".$HTTP_POST_VARS["rating"]."', updatedate='".$updateisodate."', authorid='".$authorid."', catid='".$HTTP_POST_VARS["catcode"]."' WHERE reviewsid='".$HTTP_POST_VARS["reviewsID"]."'";
   } else {
      $strQuery = "INSERT INTO ".$GLOBALS["scTable"]." VALUES('', '".$sTitle."', '".$sAuthor."', '".$sPublisher."', '".$publishisodate."', '".$HTTP_POST_VARS["contactname"]."', '".$HTTP_POST_VARS["contactemail"]."', '".$HTTP_POST_VARS["web_page"]."', '".$sTeaser."', '".$sBody."', '".$HTTP_POST_VARS["rating"]."', ".$scValid.", '".$authorid."', '".$updateisodate."', '".$HTTP_POST_VARS["catcode"]."')";
   }
   $result = dbExecute($strQuery,true);
   dbCommit();
}


function GetGlobalData()
{
   global $EZ_SESSION_VARS, $HTTP_GET_VARS, $HTTP_POST_VARS;

   $strQuery="SELECT * FROM ".$GLOBALS["scTable"]." WHERE reviewsid='".$HTTP_GET_VARS["reviewsID"]."'";
   $result = dbRetrieve($strQuery,true,0,0);
   $rs     = dbFetch($result);

   $GLOBALS["gsTitle"]          = $rs["title"];
   $GLOBALS["gsAuthor"]         = $rs["author"];
   $GLOBALS["gsPublisher"]      = $rs["publisher"];
   $GLOBALS["gsPublishDate"]    = $rs["publishdate"];
   $GLOBALS["gsContactName"]    = $rs["contactname"];
   $GLOBALS["gsContactEmail"]   = $rs["contactemail"];
   $GLOBALS["gsWeb_Page"]       = $rs["web_page"];
   $GLOBALS["gsBody"]           = $rs["body"];
   $GLOBALS["gsTeaser"]         = $rs["teaser"];
   $GLOBALS["gsRating"]         = $rs["rating"];
   $GLOBALS["gsCatCode"]        = $rs["catid"];

   $HTTP_POST_VARS["authorid"] = $rs["authorid"];
   if ($rs["authorid"] == $EZ_SESSION_VARS["UserID"]) {
      $GLOBALS["specialedit"] = True;
      $GLOBALS["fieldstatus"] = '';
   }
} // function GetGlobalData()


function GetFormData()
{
   global $EZ_SESSION_VARS, $HTTP_POST_VARS;

   $publishisodate = sprintf("%04d-%02d-%02d", $HTTP_POST_VARS["PublishYear"], $HTTP_POST_VARS["PublishMonth"], $HTTP_POST_VARS["PublishDay"]);
   $expireisodate = sprintf("%04d-%02d-%02d", $HTTP_POST_VARS["ExpireYear"], $HTTP_POST_VARS["ExpireMonth"], $HTTP_POST_VARS["ExpireDay"]);

   $GLOBALS["gsTitle"]          = $HTTP_POST_VARS["title"];
   $GLOBALS["gsAuthor"]         = $HTTP_POST_VARS["author"];
   $GLOBALS["gsPublisher"]      = $HTTP_POST_VARS["publisher"];
   $GLOBALS["gsPublishDate"]    = $publishisodate;
   $GLOBALS["gsContactName"]    = $HTTP_POST_VARS["contactname"];
   $GLOBALS["gsContactEmail"]   = $HTTP_POST_VARS["contactemail"];
   $GLOBALS["gsWeb_Page"]       = $HTTP_POST_VARS["web_page"];
   $GLOBALS["gsBody"]           = $HTTP_POST_VARS["body"];
   $GLOBALS["gsTeaser"]         = $HTTP_POST_VARS["teaser"];
   $GLOBALS["gsRating"]         = $HTTP_POST_VARS["rating"];
   $GLOBALS["gsCatCode"]        = $HTTP_POST_VARS["catcode"];

   if ($HTTP_POST_VARS["authorid"] == $EZ_SESSION_VARS["UserID"]) {
      $GLOBALS["specialedit"] = True;
      $GLOBALS["fieldstatus"] = '';
   }
} // function GetFormData()


function RenderRatings($rating)
{
   if ((intval($rating == 99)) || ($rating == '')) {
      echo '<option selected value="99">'.$GLOBALS["tUnrated"].'</option>';
   }
   for ($i=$GLOBALS["gsRatingMin"]; $i<=$GLOBALS["gsRatingMax"]; $i++) {
      echo "<option";
      if ((intval($rating) == $i) && ($rating != '')) { echo " selected"; }
      echo " value=\"".$i."\">".$i."</option>".chr(13);
   }
} // function RenderRatings()


ModuleJavaFunctions();

?>
