<?php

/***************************************************************************

 search.php
 -----------
 copyright : (C) 2002-2003 The ezContents Development Team

 ***************************************************************************/

/***************************************************************************
 The ezContents Development Team offers no warranties on this script.
 The owner/licensee of the script is solely responsible for any problems
 caused by installation of the script or use of the script.

 All copyright notices regarding ezContents must remain intact on the
 scripts and in the HTML for the scripts.

 For more info on ezContents,
 visit http://www.ezcontents.org/

/***************************************************************************

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the License which can be found within the
 *   zipped package.
 *
 ***************************************************************************/

global $HTTP_SERVER_VARS;
if ( (substr($HTTP_SERVER_VARS["PHP_SELF"],-11) == 'control.php') ||
	 (substr($HTTP_SERVER_VARS["PHP_SELF"],-10) == 'module.php') ||
	 (substr($HTTP_SERVER_VARS["PHP_SELF"],-16) == 'showcontents.php') ) {
	 require_once('./modules/moduleSec.php');
} else {
	require_once('../moduleSec.php');
}

if (!isset($GLOBALS["gsLanguage"])) { Header("Location: ".$GLOBALS["rootdp"]."module.php?link=".$GLOBALS["modules_home"]."search/search.php"); }

include_once ($GLOBALS["language_home"].$GLOBALS["gsLanguage"]."/lang_admin.php");
include_once ($GLOBALS["language_home"].$GLOBALS["gsLanguage"]."/lang_main.php");
include_languagefile ($GLOBALS["modules_home"]."search/",$GLOBALS["gsLanguage"],"lang_search.php");


$SAVE_VARS["topgroupname"] = $HTTP_GET_VARS["topgroupname"];
$SAVE_VARS["groupname"] = $HTTP_GET_VARS["groupname"];
$SAVE_VARS["subgroupname"] = $HTTP_GET_VARS["subgroupname"];

define('searchin_title',0);
define('searchin_teaser',1);
define('searchin_content',2);

if (!$HTTP_POST_VARS["submit"]) {
	// Set a few default values
	$HTTP_POST_VARS["keywords"] = "";
	if ($GLOBALS["search"]["addterms"] == '') { $GLOBALS["search"]["addterms"] = "any"; }
	$HTTP_POST_VARS["addterms"] = $GLOBALS["search"]["addterms"];
	$HTTP_POST_VARS["searchin_array"] = array(searchin_title,searchin_content);
}
$SearchString = stripslashes($HTTP_POST_VARS["keywords"]);

SubFormHeader('Search');
?>
<table border="1" cellpadding="1" cellspacing="0" align="center" valign="top" width="100%" class="headercontent">
	<tr><td class="header"><?php echo $GLOBALS["module_title"]; ?></td>
	</tr>
	<tr><td class="tablecontent">
			<table border="0" cellpadding="0" cellspacing="0" width="100%">
				<tr><td colspan=2 width="50%" align="<?php echo $GLOBALS["right"]; ?>" valign="middle"><b><?php echo $GLOBALS["search_keywords"]; ?>:</b>&nbsp;</td>
					<td colspan=2 width="50%" valign="top"><input type="text" size="42" name="keywords" value="<?php echo htmlspecialchars($SearchString); ?>"></td>
				</tr>
				<tr><td width="40%" align="<?php echo $GLOBALS["right"]; ?>" valign="middle"><b><?php echo $GLOBALS["search_OR"]; ?>:</b>&nbsp;</td>
					<td width="10%" valign="top"><input type="radio" name="addterms" value="any"<?php if ($HTTP_POST_VARS["addterms"] == "any") { echo " checked"; } ?>></td>
					<td width="40%" align="<?php echo $GLOBALS["right"]; ?>" valign="middle"><b><?php echo $GLOBALS["search_titles"]; ?>:</b>&nbsp;</td>
					<td width="10%" valign="top"><input type="checkbox" name="searchin_array[]" value="<?php echo searchin_title; ?>"<?php if ((isset($HTTP_POST_VARS["searchin_array"])) && (in_array(searchin_title, $HTTP_POST_VARS["searchin_array"]))) echo " checked"; ?>></td>
				</tr>
				<tr><td width="40%" align="<?php echo $GLOBALS["right"]; ?>" valign="top"><b><?php echo $GLOBALS["search_AND"]; ?>:</b>&nbsp;</td>
					<td width="10%" valign="top"><input type="radio" name="addterms" value="all"<?php if ($HTTP_POST_VARS["addterms"] == "all") { echo " checked"; } ?>></td>
					<td width="40%" align="<?php echo $GLOBALS["right"]; ?>" valign="top"><b><?php echo $GLOBALS["search_teasers"]; ?>:</b>&nbsp;</td>
					<td width="10%" valign="top"><input type="checkbox" name="searchin_array[]" value="<?php echo searchin_teaser; ?>"<?php if ((isset($HTTP_POST_VARS["searchin_array"])) && (in_array(searchin_teaser, $HTTP_POST_VARS["searchin_array"]))) echo " checked"; ?>></td>
				</tr>
				<tr><td colspan=3 width="90%" align="<?php echo $GLOBALS["right"]; ?>" valign="top"><b><?php echo $GLOBALS["search_contents"]; ?>:</b>&nbsp;</td>
					<td width="10%" valign="top"><input type="checkbox" name="searchin_array[]" value="<?php echo searchin_content; ?>"<?php if ((isset($HTTP_POST_VARS["searchin_array"])) && (in_array(searchin_content, $HTTP_POST_VARS["searchin_array"]))) echo " checked"; ?>></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr><td class="header"><input type="Submit" name="submit" value="<?php echo $GLOBALS["search_button"]; ?>"></td>
	</tr>
</table>
<?php
SubFormFooter();


$isodate = sprintf ("%04d-%02d-%02d", strftime("%Y"), strftime("%m"), strftime("%d"));
if ($HTTP_POST_VARS["submit"]) {
	$querytitle = $querycontent = $queryteaser = "";
	$strQuery = "SELECT * FROM ".$GLOBALS["eztbContents"]." WHERE ";

	if (isset($SearchString) && $SearchString != "") {
		//	Parse the input string, separating word strings and sentence strings (delimited by ") into two separate arrays
		preg_match_all('!("(.*)")!iU',$SearchString,$sentences);
		$single_words = preg_split('!("(.*)")!iU',$SearchString);
		foreach($single_words as $text) {
		    if (!trim($text)) continue;
		    $temp = explode(' ',trim($text));
		    if (is_array($temp)) { $Tokens=array_merge($temp,$Tokens); } else { $Tokens[]=trim($temp); }
		}
		//	Merge the sentences and words arrays
		$Tokens=array_merge($sentences[2],$Tokens);
		//	Remove duplicate search entries
		$Tokens=array_unique ($Tokens);
		//	Drop blank entries created by removal of duplicates
		reset ($Tokens);
		while (list ($key, $val) = each ($Tokens)) {
		    $ValidTokens[] = addslashes($val);
		}

		$querytitle .= "(title LIKE '%$ValidTokens[0]%'";
		$querycontent .= "(cbody LIKE '%$ValidTokens[0]%'";
		$queryteaser .= "(cteaser LIKE '%$ValidTokens[0]%'";
		if ($HTTP_POST_VARS["addterms"] == "any") { $andor = "OR"; } else { $andor = "AND"; }
		$nbrterms = sizeof($ValidTokens);
		for ($i=1; $i<$nbrterms; $i++) {
			$querytitle .= " $andor title LIKE '%$ValidTokens[$i]%'";
			$querycontent .= " $andor cbody LIKE '%$ValidTokens[$i]%'";
			$queryteaser .= " $andor cteaser LIKE '%$ValidTokens[$i]%'";
		}
		$querytitle .= ")";
		$querycontent .= ")";
		$queryteaser .= ")";
	} else {
		?>
		<table border="1" cellpadding="1" cellspacing="0" align="center" valign="top" width="100%" class="headercontent">
			<tr><td class="tablecontent">&nbsp;<br /><?php echo $GLOBALS["eEnterKeywords"]; ?><br />&nbsp;</td></tr>
		</table>
		<?php
		if (($GLOBALS["gsUseFrames"] == 'Y') && ($EZ_SESSION_VARS["noframesbrowser"] != True)) {
			?>
			</body>
			</html>
			<?php
		} else {
			?>
			</td></tr>
			</table>
			<?php
		}
		exit;
	}

	$whereset = false;
	if (isset($HTTP_POST_VARS["searchin_array"])) {
		$strQuery .= '(';
		if (in_array(searchin_title, $HTTP_POST_VARS["searchin_array"])) {
			$strQuery .= "$querytitle";
			$whereset = true;
		}
		if (in_array(searchin_teaser, $HTTP_POST_VARS["searchin_array"])) {
			if ($whereset) { $strQuery .= " OR "; }
			$strQuery .= $queryteaser;
			$whereset = true;
		}
		if (in_array(searchin_content, $HTTP_POST_VARS["searchin_array"])) {
			if ($whereset) { $strQuery .= " OR "; }
			$strQuery .= $querycontent;
			$whereset = true;
		}
		$strQuery .= ") AND contentactive='1' AND publishdate<='".$isodate."' AND expiredate>='".$isodate."'";
	}

	if ($whereset == false) {
		?>
		<table border="1" cellpadding="1" cellspacing="0" align="center" valign="top" width="100%" class="headercontent">
			<tr><td class="tablecontent">&nbsp;<br /><?php echo $GLOBALS["eEnterElements"]; ?><br />&nbsp;</td></tr>
		</table>
		<?php
		if (($GLOBALS["gsUseFrames"] == 'Y') && ($EZ_SESSION_VARS["noframesbrowser"] != True)) {
			?>
			</body>
			</html>
			<?php
		} else {
			?>
			</td></tr>
			</table>
			<?php
		}
		exit;
	}

	if ($GLOBALS["gsLanguage"] == $GLOBALS["gsDefault_language"]) { $strQuery .= " AND language='".$GLOBALS["gsLanguage"]."' ORDER BY contentname";
	} else {
		$lOrder = '';
		if ($GLOBALS["gsLanguage"] > $GLOBALS["gsDefault_language"]) { $lOrder = ' DESC'; }
		$strQuery .= " AND (language='".$GLOBALS["gsLanguage"]."' OR language='".$GLOBALS["gsDefault_language"]."') ORDER BY contentname,language".$lOrder;
	}

	?>
	<center>
	<?php
	$result = dbRetrieve($strQuery,true,0,0);
	$results_found = dbRowsReturned($result);
	$bArticleCount = 0;

	if ($results_found != 0) {
		$nContentName = '';
		while ($rsContent = dbFetch($result)) {
			if ($rsContent["contentname"] != $nContentName) {
				if (ModArticleSecurity($nContentName,$rsContent)) {
					ShowArticle($rsContent);
					$bArticleCount++;
				}
				$nContentName = $rsContent["contentname"];
			}
		}
	}

	if ($bArticleCount == 0) {
		?>
		<table border="1" cellpadding="1" cellspacing="0" align="center" valign="top" width="100%" class="headercontent">
			<tr><td class="tablecontent">&nbsp;<br /><?php echo $GLOBALS["eNoResults"]; ?><br />&nbsp;</td></tr>
			</table>
		<?php
	}
	?>
	</center>
	<?php
	dbFreeResult($result);
}

$HTTP_GET_VARS["topgroupname"] = $SAVE_VARS["topgroupname"];
$HTTP_GET_VARS["groupname"] = $SAVE_VARS["groupname"];
$HTTP_GET_VARS["subgroupname"] = $SAVE_VARS["subgroupname"];

?>
