<?php
require_once(ROOT.'libs/JSON.php');

if( !function_exists('json_encode') ) {
	function json_encode($data) {
		$json = new Services_JSON();
		return( $json->encode($data) );
	}
}

if( !function_exists('json_decode') ) {
	function json_decode($data, $bool) {
		if ($bool) {
			$json = new Services_JSON(SERVICES_JSON_LOOSE_TYPE);
		} else {
			$json = new Services_JSON();
		}
		return( $json->decode($data) );
	}
}

function d($o) {
	if(DEBUG) {
		print("\n<pre>\n");
		switch(gettype($o)) {
			case "object":
			case "resource":
			case "NULL":
				var_dump($o);break;
			case "array":
				print_r($o);break;
			case "unknown type":
				print("unknown type");break;
			default:
				print($o);break;
		}
		print("\n</pre>\n");
	}
}
function redirect_to($url) {
  echo '<meta http-equiv="refresh" content="0; url='.$url.'">';
  exit;
}

function my_encoding($data,$to){
	$encode_arr = array('UTF-8','GBK','GB2312','BIG5');
	$encoded = mb_detect_encoding($data, $encode_arr);
	$data = mb_convert_encoding($data,$to,$encoded);
	return $data;
}

function var_request($key, $default){
	$value = $default;
	if(isset($_GET[$key])) {$value = $_GET[$key];}
	return $value;
}

function create_sign($params) {
	ksort($params);
	$signs = array(SIP_APPSECRET);
	foreach($params as $key => $value) {
		$signs[] = $key.$value;
	}
	return strtoupper(md5(implode("", $signs)));
}

function create_query($params) {
	ksort($params);
	$querys = array();
	foreach($params as $key => $value) {
		$querys[] = $key."=".urlencode($value);
	}
	return implode("&", $querys);
}

function service_call($api_name, $params = array()) {
	$params['app_key'] = SIP_APPKEY;
	$params['method'] = $api_name;
	$params['format'] = SIP_FORMAT;
	$params['v'] = SIP_VERSION;
	$params['timestamp'] = date("Y-m-d H:i:s");
	
	$sign = create_sign($params);
	$results = fetch_url(SIP_URL."?".create_query($params)."&sign=".$sign);
	//d($results);
	$json = json_decode($results,true);
	
	if(!isset($json['rsp']) || empty($json['rsp'])){return false;}
	return $json['rsp'];
}

function fetch_url( $url ){
	require_once(ROOT.'libs/Snoopy.class.php');
	$snoopy = new Snoopy();
	//d($url);
	$snoopy->fetch($url);
	$results = $snoopy->results;
	$snoopy = null;
	return $results;
}

function my_lookup($string, $option = array()) {
  $regex = $option["regex"];
  $keyword = $option["keyword"];
  if($keyword) {
    $lookup_index = $option["lookup_index"] + 1;
  }
  $return_index = $option["return_index"] + 1;

  preg_match_all($regex, $string, $matches);

  $length = count($matches[$return_index]);

  for($i = 0; $i < $length; $i++) {
    if($keyword) {
      if($keyword == trim($matches[$lookup_index][$i])) {
        return(trim($matches[$return_index][$i]));
      }
    }else {
      if($matches[$return_index][$i]) {
        return(trim($matches[$return_index][$i]));
      }
    }
  }
  return null;
}

function http_get_item_ext_info($iid) {
	$response = fetch_url(ITEM_EXT_INFO.$iid);
	$num_of_sold = my_lookup($response,
	array(
	"regex" => "[(.+)</span><em>(\d+)</em>]",
	"keyword" => iconv("UTF-8", "GBK", "30۳"),
	"lookup_index" => 0,
	"return_index" => 1));
	$num_of_fav = my_lookup($response,
	array(
	"regex" => "[<li><span>(.+)</span>(\d+)&nbsp;]",
	"keyword" => iconv("UTF-8", "GBK", "ղ"),
	"lookup_index" => 0,
	"return_index" => 1));
	$text_of_promotion = my_lookup($response,
	array(
	"regex" => "[<div class=\"fence promotion\">.*?<p>(.*?)</p>]s",
	"keyword" => false,
	"return_index" => 0));

	$consumer_protection = my_lookup($response,
	array(
	"regex" => "[<a href=\"http://www\.taobao\.com/go/act/315/(xfzbzfw)\.PHP\?ad_id=&am_id=1300117110a02b16093f&cm_id=&pm_id=&xbjc=2\.0\" target=\"_blank\">]",
	"keyword" => false,
	"return_index" => 0));
	$can_be_returned = my_lookup($response,
	array(
	"regex" => "[<a href=\"http://www\.taobao\.com/go/act/315/(xbqt090304)\.php\?ad_id=&am_id=130011831021c2f3caab&cm_id=&pm_id=&xbjc=2\.2\" class=\"safe-7\" target=\"_blank\">]",
	"keyword" => false,
	"return_index" => 0));
	$truth_desc = my_lookup($response,
	array(
	"regex" => "[<a href=\"http://www\.taobao\.com/go/act/315/(xfzbz_rsms)\.php\?ad_id=&am_id=130011830696bce9eda3&cm_id=&pm_id=&xbjc=2\.1\" class=\"safe-3\" target=\"_blank\">]",
	"keyword" => false,
	"return_index" => 0));
	return array(
	"num_of_sold" => (int)$num_of_sold,
	"num_of_fav" => (int)$num_of_fav,
	"text_of_promotion" => iconv("GBK", "UTF-8", strip_tags($text_of_promotion,"<em>")),
	"consumer_protection" => (int)($consumer_protection == "xfzbzfw"),
	"can_be_returned" => (int)($can_be_returned == "xbqt090304"),
	"truth_desc" => (int)($truth_desc == "xfzbz_rsms"),
	// "auth3" => (int)($auth3 == "xfzbz_jyps")
	);
}

function credit_pic($level, $type='s'){
	$credit_pics = array(
		  "img/shang.gif",
		  "http://pics.taobaocdn.com/newrank/{$type}_red_1.gif",
		  "http://pics.taobaocdn.com/newrank/{$type}_red_2.gif",
		  "http://pics.taobaocdn.com/newrank/{$type}_red_3.gif",
		  "http://pics.taobaocdn.com/newrank/{$type}_red_4.gif",
		  "http://pics.taobaocdn.com/newrank/{$type}_red_5.gif",
		  "http://pics.taobaocdn.com/newrank/{$type}_blue_1.gif",
		  "http://pics.taobaocdn.com/newrank/{$type}_blue_2.gif",
		  "http://pics.taobaocdn.com/newrank/{$type}_blue_3.gif",
		  "http://pics.taobaocdn.com/newrank/{$type}_blue_4.gif",
		  "http://pics.taobaocdn.com/newrank/{$type}_blue_5.gif",
		  "http://pics.taobaocdn.com/newrank/{$type}_cap_1.gif",
		  "http://pics.taobaocdn.com/newrank/{$type}_cap_2.gif",
		  "http://pics.taobaocdn.com/newrank/{$type}_cap_3.gif",
		  "http://pics.taobaocdn.com/newrank/{$type}_cap_4.gif",
		  "http://pics.taobaocdn.com/newrank/{$type}_cap_5.gif",
		  "http://pics.taobaocdn.com/newrank/{$type}_crown_1.gif",
		  "http://pics.taobaocdn.com/newrank/{$type}_crown_2.gif",
		  "http://pics.taobaocdn.com/newrank/{$type}_crown_3.gif",
		  "http://pics.taobaocdn.com/newrank/{$type}_crown_4.gif",
		  "http://pics.taobaocdn.com/newrank/{$type}_crown_5.gif"
		);
	return $credit_pics[$level];
}

function good( $good=0, $total=0){
	return round(($good/$total)*100,2)."%";
}

function clearhtml($str){
	return strip_tags($str);
}

function sortname($sr){
	if( $sr != 'commissionNum_desc' && $sr != 'price_desc' && $sr != 'price_asc' && $sr != 'credit_desc' ){
		return 'commissionNum_desc';
	} else {
		return $sr;
	}
}