<?php
function updatecaches(){
	@set_time_limit(0);
	global $db,$db_mymps,$mymps_global;
	clear_cache_files();
	write_admin_cache();
	updateadvertisement();
	write_cron_cache();
	write_checkanswer_cache();
	update_checkanswer_settings();
	update_jswizard_settings();
	write_jswizard_cache();
	write_authcode_cache();
	write_plugin_cache();
	write_insidelink_cache();
}

function get_mobile_settings(){
	global $db,$db_mymps;
	$data = read_static_cache('mobile');
	if($data === false){
		clear_cache_files('mobile');
		$res = $db->getOne("SELECT value FROM `{$db_mymps}config` WHERE type='mobile' AND description = 'mobile'");
		$res = $res ? ($charset == 'utf-8' ? utf8_unserialize($res) : unserialize($res)) : array();
		write_static_cache('mobile',$res);
	}else{
		$res = $data;
	}
	return $res;
}

function get_commentsettings(){
	global $db,$db_mymps;
	$data = read_static_cache('commentsettings');
	if($data === false){
		clear_cache_files('commentsettings');
		$res = $db->getOne("SELECT value FROM `{$db_mymps}config` WHERE type='comment' AND description = 'comment'");
		$res = $res ? ($charset == 'utf-8' ? utf8_unserialize($res) : unserialize($res)) : array();
		write_static_cache('commentsettings',$res);
	}else{
		$res = $data;
	}
	return $res;
}

function get_information_count(){
	global $db,$db_mymps;
	$data = read_static_cache('information_count');
	if($data === false){
		clear_cache_files('information_count');
		//췢Ϣ
		$sql = "SELECT SQL_BIG_RESULT catid,count(*) AS num FROM {$db_mymps}information group by catid";
		$counts = $db->getAll($sql);
		$res = array();
		foreach($counts as $k=>$v){
			$res[$v['catid']] = $v['num'];
		}
		write_static_cache('information_count',$res);
	}else{
		$res = $data;
	}
	return $res;
}

function write_insidelink_cache(){
	global $db,$db_mymps,$charset;
	clear_cache_files('insidelink');
	$query = $db -> query("SELECT * FROM `{$db_mymps}insidelink`");
	while($row = $db -> fetchRow($query)){
		$res['detail'][$row['word']] = $row['url'];
	}
	
	$settings = $db -> getOne("SELECT value FROM `{$db_mymps}config` WHERE type = 'insidelink' AND description = 'insidelink'");
	$res['settings'] = ($charset == 'gbk') ? unserialize($settings) : utf8_unserialize($settings);
	
	write_static_cache('insidelink',$res);
}

function updateadvertisement(){
	global $timestamp;
	$query = $GLOBALS['db'] -> query("SELECT * FROM `{$GLOBALS['db_mymps']}advertisement` WHERE available>'0' AND starttime<='$timestamp' AND type != 'normalad' ORDER BY displayorder ASC");
	if($GLOBALS['db']->num_rows($query)) {
		while($adv = $GLOBALS['db']->fetchRow($query)) {
			foreach(explode("\t",$adv['targets']) as $target){
				if($adv['type'] == 'indexcatad' && is_numeric($target)) {
					/*Ϊҳ*/
					$advs['index']['type'][$adv['type']][$target][] = $adv['advid'];
					$advs['index']['items'][$adv['advid']]  = $adv['code'];
				}elseif($target == 'index'){
					//Ϊҳʾ
					$advs['index']['type'][$adv['type']][] 	= $adv['advid'];
					$advs['index']['items'][$adv['advid']]  = $adv['code'];
				}elseif($target == 'all'){
					$position = $charset == 'gbk' ? unserialize($adv['parameters']) : utf8_unserialize($adv['parameters']);
					foreach(array('category','info','index','other') as $range){
						if($position['position']){
							$advs[$range][$target]['type'][$adv['type']][$position['position']][] = $adv['advid'];
						}else{
							$advs[$range][$target]['type'][$adv['type']][] = $adv['advid'];
						}
						$advs[$range]['items'][$adv['advid']]  = $adv['code'];
					}
				} elseif(is_numeric($target)){
					//Ϊ ΪĿinfoĶҳʾ
					$position = $charset == 'gbk' ? unserialize($adv['parameters']) : utf8_unserialize($adv['parameters']);
					foreach(array('category','info') as $range){
						if($position['position']){
							$advs[$range][$target]['type'][$adv['type']][$position['position']][] = $adv['advid'];
						} else {
							$advs[$range][$target]['type'][$adv['type']][] = $adv['advid'];
						}
						$advs[$range]['items'][$adv['advid']]  = $adv['code'];
					}
				}
			}
		}
		
		foreach(array('index','category','info','other') as $range){
			write_static_cache('adv_'.$range,$advs[$range]);
		}
	}
	
}

function write_cron_cache(){
	global $db,$db_mymps,$timestamp;
	$query = $db->query("SELECT * FROM `{$db_mymps}crons` WHERE 1 OR nextrun = '0'");
	while($row = $db -> fetchRow($query)){
		$res[$row['name']]['lastrun'] = $row['lastrun'];
		$res[$row['name']]['nextrun'] = $row['nextrun'];
		$res[$row['name']]['day'] 	  = $row['day'];
	}
	$content = "<?php\r\n";
    $content .= "\$m_cron = " . var_export($res, true) . ";\r\n";
    $content .= "?>";
	if(!createfile(MYMPS_DATA.'/cron.cache.php',$content)){
		write_msg(MYMPS_DATA.'/cron.cache.php ļдӦȨ');
	}
}

function write_authcode_cache(){
	global $db,$db_mymps;
	clear_cache_files('authcodesettings');
	$query = $db -> query("SELECT * FROM `{$db_mymps}config` WHERE type = 'authcode'");
	while($row = $db -> fetchRow($query)){
		$res[$row['description']] = $row['value'];
	}
	write_static_cache('authcodesettings',$res);
}

/*֤ش𻺴*/
function write_checkanswer_cache(){
	$query = $GLOBALS['db'] -> query("SELECT * FROM `{$GLOBALS['db_mymps']}checkanswer` ORDER BY id DESC");
	while($row = $GLOBALS['db'] -> fetchRow($query)){
		$res[$row['id']]['id'] = $row['id'];
		$res[$row['id']]['question'] = $row['question'];
		$res[$row['id']]['answer'] = $row['answer'];
	}
	write_static_cache('checkanswer',$res);
}

function update_checkanswer_settings(){
	global $db,$db_mymps;
	clear_cache_files('checkanswer_settings');
	$query = $db -> query("SELECT * FROM `{$db_mymps}config` WHERE type = 'checkanswe'");
	while($row = $db -> fetchRow($query)){
		$res[$row['description']] = $row['value'];
	}
	write_static_cache('checkanswer_settings',$res);
}

function update_config_cache(){
	$query = $GLOBALS['db'] -> query("SELECT description,value FROM `{$GLOBALS['db_mymps']}config` WHERE type = 'config'");
	while($row = $GLOBALS['db']->fetchRow($query)){
		$res[$row['description']] = $row['value'];
	}
	$content = "<?php\r\n";
    $content .= "\$mymps_global = " . var_export($res, true) . ";\r\n";
    $content .= "?>";
	if(!createfile(MYMPS_DATA.'/config.php',$content)){
		write_msg(MYMPS_DATA.'/config.php ļдӦȨޣ');
	}
}

function write_htmlstyle_cache($style = 'news'){
	global $db,$db_mymps;
	$row = $db->getRow("SELECT value FROM `{$db_mymps}config` WHERE description = 'glb_html_".$style."'");
	$mymps .= "<?php\n";
	$mymps .= "\$htmlstyle[$style] = '$row[value]';\n";
	$mymps .= "?>";
	!createfile(MYMPS_DATA.'/html_style.inc.php',$mymps) && write_msg(MYMPS_DATA."/html_style.inc.php ļдӦȨ");
}

/**
 *  ָ׺ģ建ļ
 *
 * @access  public
 * @param  bool       $is_cache  Ƿ滹ļ
 * @param  string     $ext       Ҫɾļ׺
 * is_cache  	1=ϵͳ  2=ģ建ļ 3=ģļ
 * @return int        ļ
 */
function clear_tpl_files($is_cache = 1, $ext = '')
{
    $dirs = array();
    if ($is_cache == 1){
        $dirs[] = MYMPS_DATA . '/caches/';
    }elseif($is_cache == 2){
        $dirs[] = MYMPS_DATA . '/smarty/caches/';
    } elseif($is_cache == 3){
		$dirs[] = MYMPS_DATA . '/smarty/compiles/';
	}
    $str_len = strlen($ext);
    $count   = 0;
    foreach ($dirs AS $dir){
        $folder = @opendir($dir);

        if ($folder === false){
            continue;
        }

        while ($file = readdir($folder)){
            if ($file == '.' || $file == '..' || $file == 'index.htm' || $file == 'index.html'){
                continue;
            }
            if (is_file($dir . $file)){
                /* ļжǷƥ */
                $pos = strrpos($file, '.');
                if ($str_len > 0 && $pos !== false){
                    $ext_str = substr($file, 0, $pos);

                    if ($ext_str == $ext){
                        if (@unlink($dir . $file)){
                            $count++;
                        }
                    }
                }else{
                    if (@unlink($dir . $file)){
                        $count++;
                    }
                }
            }
        }
        closedir($folder);
    }

    return $count;
}


/**
 * ģ滺ļ
 *
 * @access  public
 * @param   mix     $ext    ģļ ׺
 * @return  void
 */
function clear_smt_cache_files($ext = '')
{
    return clear_tpl_files(2, $ext);
}

/**
 * ģļ
 *
 * @access  public
 * @param   mix     $ext    ģļ ׺
 * @return  void
 */
function clear_compiled_files($ext = '')
{
    return clear_tpl_files(3, $ext);
}

/**
 * ϵͳļ
 *
 * @access  public
 * @param   mix     $ext    ģļ ׺
 * @return  void
 */
function clear_cache_files($ext = '')
{
    return clear_tpl_files(1, $ext);
}

/**
 * ģͻļ
 *
 * @access  public
 * @param   mix     $ext    ģļ׺
 * @return  void
 */
function clear_all_files($ext = '')
{
    return clear_tpl_files(1, $ext) + clear_tpl_files(2,  $ext) + clear_tpl_files(3,  $ext);
}

function clear_smarty_files(){
	clear_tpl_files(2,  $ext) + clear_tpl_files(3,  $ext);
}

function read_static_cache($cache_name){
    if ((DEBUG_MODE & 2) == 2){
        return false;
    }
    static $result = array();
    if (!empty($result[$cache_name])){
        return $result[$cache_name];
    }
    $cache_file_path = MYMPS_DATA . '/caches/' . $cache_name . '.php';
    if (file_exists($cache_file_path)){
        include_once($cache_file_path);
        $result[$cache_name] = $data;
        return $result[$cache_name];
    }else{
        return false;
    }
}

function write_static_cache($cache_name, $caches){
    if ((DEBUG_MODE & 2) == 2){
        return false;
    }
    $cache_file_path = MYMPS_DATA . '/caches/' . $cache_name . '.php';
    $content = "<?php\r\n";
    $content .= "\$data = " . var_export($caches, true) . ";\r\n";
    $content .= "?>";
    file_put_contents($cache_file_path, $content, LOCK_EX);
}

function get_cache_config(){
	$data = read_static_cache('cache');
	if($data === false){
		$query = $GLOBALS['db'] -> query("SELECT * FROM `{$GLOBALS['db_mymps']}cache`");
		while($row = $GLOBALS['db']->fetchRow($query)){
			$cache[$row['page']]['time'] = $row['time'];
			$cache[$row['page']]['open'] = $row['open'];
		}
		write_static_cache('cache',$cache);
	} else {
		$cache = $data;
	}
	return $cache;
}

function update_jswizard_settings(){
	global $db,$db_mymps;
	clear_cache_files('jswizard_settings');
	$query = $db -> query("SELECT * FROM `{$db_mymps}config` WHERE type = 'jswizard'");
	while($row = $db -> fetchRow($query)){
		$res[$row['description']] = $row['value'];
	}
	write_static_cache('jswizard_settings',$res);
}

function write_jswizard_cache(){
	global $db,$db_mymps,$charset;
	clear_cache_files('jswizard_lists');
	$query = $db -> query("SELECT * FROM `{$db_mymps}jswizard`");
	while($row = $db -> fetchRow($query)){
		$res[$row['flag']]['id'] 	= $row['id'];
		$res[$row['flag']]['flag'] 	= $row['flag'];
		$res[$row['flag']]['parameter'] = $charset == 'utf-8' ? utf8_unserialize($row['parameter']) : unserialize($row['parameter']);		
	}
	write_static_cache('jswizard_lists',$res);
}

function write_admin_cache(){
	clear_cache_files('admin');
	$query = $GLOBALS['db'] -> query("SELECT a.*,b.purviews,b.typename,b.ifsystem FROM `{$GLOBALS['db_mymps']}admin` AS a LEFT JOIN `{$GLOBALS['db_mymps']}admin_type` AS b ON a.typeid = b.id");
	while($row = $GLOBALS['db'] -> fetchRow($query)){
		$res[$row['userid']]['typename']	=	$row['typename'];
		$res[$row['userid']]['ifsystem']	=	$row['ifsystem'];
		$res[$row['userid']]['purviews']	=	$row['purviews'];
	}
	write_static_cache('admin',$res);
}

/*жĳǷװ*/
function write_plugin_cache(){
	global $db,$db_mymps,$charset;
	clear_cache_files('plugin');
	$query = $db -> query("SELECT * FROM `{$db_mymps}plugin`");
	while($row = $db -> fetchRow($query)){
		$res[$row['flag']]['id'] = $row['id'];
		$res[$row['flag']]['flag'] = $row['flag'];
		$res[$row['flag']]['iscore'] = $row['iscore'];
		$res[$row['flag']]['name'] = $row['name'];
		$res[$row['flag']]['directory'] = $row['directory'];
		$res[$row['flag']]['disable'] = $row['disable'];
		$config = $charset == 'utf-8' ? utf8_unserialize($row['config']) : unserialize($row['config']);
		$res[$row['flag']]['ifrewrite'] = $config['ifrewrite'];
		$res[$row['flag']]['seotitle'] = $config['seotitle'];
		$res[$row['flag']]['seokeywords'] = $config['seokeywords'];
		$res[$row['flag']]['seodescription'] = $config['seodescription'];
		$res[$row['flag']]['adminmenu'] = $config['adminmenu'];
		$res[$row['flag']]['membermenu'] = $config['membermenu'];
		if($row['flag'] == 'goods'){
			$res[$row['flag']]['quhuo'] = $config['quhuo'];
			$res[$row['flag']]['fukuan'] = $config['fukuan'];
			$res[$row['flag']]['service'] = $config['service'];
		}
		$res[$row['flag']]['version'] = $row['version'];
		$res[$row['flag']]['releasetime'] = $row['releasetime'];
		$res[$row['flag']]['author'] = $row['author'];
		$res[$row['flag']]['introduce'] = $row['introduce'];
		$res[$row['flag']]['siteurl'] = $row['siteurl'];
		$res[$row['flag']]['email'] = $row['email'];
		$res[$row['flag']]['copyright'] = $row['copyright'];
	}
	write_static_cache('plugin',$res);
	clear_cache_files('pluginmenu_admin');
	clear_cache_files('pluginmenu_member');
	@include MYMPS_DATA.'/caches/plugin.php';
	if(is_array($data)){
		foreach($data as $key => $val){
			if($val['disable'] != 1){
				$adminmenu[$val['name']]  = arraychange($val['adminmenu']);
				$membermenu[$val['flag']] = $val['name'];
				write_static_cache('pluginmenu_admin',$adminmenu);
				write_static_cache('pluginmenu_member',$membermenu);
			}
		}
	}
}

/*ȡ*/
function get_credit_score(){
	global $db,$db_mymps,$charset;
	$data = read_static_cache('credit_score');
	if($data === false){
		clear_cache_files('score_credit');
		
		$query = $db -> query("SELECT * FROM `{$db_mymps}config` WHERE type = 'credit_sco'");
		while($row = $db -> fetchRow($query)){
			$res[$row['description']] = $charset == 'utf-8' ? utf8_unserialize($row['value']) : unserialize($row['value']);
		}

		write_static_cache('credit_score',$res);
	}else{
		$res = $data;
	}
	return $res;
}

/*ȡҳģ*/
function get_tpl_index(){
	global $db,$db_mymps,$charset;
	$data = read_static_cache('tpl_index');
	if($data === false){
		clear_cache_files('tpl_index');
		
		$query = $db -> query("SELECT * FROM `{$db_mymps}config` WHERE type = 'tpl'");
		while($row = $db -> fetchRow($query)){
			$res[$row['description']] = $charset == 'utf-8' ? utf8_unserialize($row['value']) : unserialize($row['value']);
		}

		write_static_cache('tpl_index',$res);
	}else{
		$res = $data;
	}
	return $res;
}

function get_category_dir(){
	$data = read_static_cache('category_dir');
	if($data === false){
		$query = $GLOBALS['db'] -> query("SELECT catid,dir_typename FROM `{$GLOBALS['db_mymps']}category`");
		while($row = $GLOBALS['db']->fetchRow($query)){
			$cache[$row['catid']] = $row['dir_typename'];
		}
		write_static_cache('category_dir',$cache);
	} else {
		$cache = $data;
	}
	return $cache;
}
?>