using System;
using System.Web;
using System.Web.UI;
using System.Text.RegularExpressions;

public class PageLoader : IHttpModule
{
  // static Regex that extracts the article name
  Regex regex = new Regex("/Articles/(.+)$");

  // required by IHttpModule
  public void Init(HttpApplication app)
  {
    // add a new handler for application's BeginRequest event
    app.BeginRequest += new System.EventHandler(this.BeginRequest);
  }

  // performs URL rewriting
  public void BeginRequest(object s, EventArgs e)
  {
    // get the current context
    HttpContext context = HttpContext.Current;

    // this module only rewrites article requests
    Match match = regex.Match(context.Request.FilePath);
    if (match.Groups.Count < 2) return;

    // get the article name
    string pageName = match.Groups[1].Value;

    // rewrite the URL depending on the requested page
    if (pageName.ToLower() == "ajax-php-book-review.html")
    {
      // assume the ID of the AJAX-PHP-Book-Review.html article is 35
      context.RewritePath("~/Product.aspx?ProductID=35");
    }
    else
    {
      // return a 404 status code if the article name wasn't recognized
      context.Response.Status = "404 Not Found";
    }
  }

  // required by IHttpModule
  public void Dispose()
  {
    //  add clean-up code here if required
  }
}
