<%@ WebHandler Language="C#" Class="Loader" %>

using System;
using System.Web;
using System.Web.UI;

public class Loader : IHttpHandler
{
  public void ProcessRequest(HttpContext context)
  {
    // get the value of the Page parameter
    string pageName = context.Request.QueryString["Page"];

    // stop if there's no Page parameter
    if (pageName == null || pageName == "") return;

    // rewrite the URL depending on the requested page
    if (pageName.ToLower() == "ajax-php-book-review.html")
    {
      // assume the ID of the AJAX-PHP-Book-Review.html article is 35
      context.RewritePath("/Product.aspx?ProductID=35");

      // create an compiled instance of the page we want to load
      IHttpHandler handler = PageParser.GetCompiledPageInstance("Product.aspx", null, context);

      // load the new page    
      handler.ProcessRequest(context);
    }
    else
    {
      // return a 404 status code if the article name wasn't recognized
      context.Response.Status = "404 Not Found";
      return;
    }
  }

  public bool IsReusable
  {
    get
    {
      return true;
    }
  }
}
