using System;
using System.Web;
using System.Configuration;

/// <summary>
/// Class provides support for URL manipulation and redirection
/// </summary>
public static class UrlTools
{
  // obtain the site domain from the configuration file
  static string siteDomain = ConfigurationManager.AppSettings["SiteDomain"];
/*
  // saves affiliate ID to the session
  public static void SaveAffiliate()
  {
    // get the affiliate ID
    HttpContext context = HttpContext.Current;
    string affiliateId = context.Request.QueryString["Aff"];

    // affiliate?
    if (affiliateId != null && context.Session != null)
    {
      context.Session["AffiliateID"] = affiliateId.ToString();
    }
  }  */

  // saves affiliate ID as a persistent cookie
  public static void SaveAffiliate()
  {
    // get the affiliate ID
    HttpContext context = HttpContext.Current;
    string affiliateId = context.Request.QueryString["Aff"];

    // affiliate?
    if (affiliateId != null)
    {
      // create the new cookie
      HttpCookie cookie = new HttpCookie("AffiliateID", affiliateId);

      // make the cookie valid for 30 days
      cookie.Expires = DateTime.Now.AddDays(30);
      
      // save the cookie
      context.Response.Cookies.Add(cookie);
    }
  }

  /* ensures the current page is being loaded through its standard URL;
   * 301 redirect to the standard URL if it doesn't */
  public static void CheckUrl()
  {
    HttpContext context = HttpContext.Current;
    HttpRequest request = HttpContext.Current.Request;

    // retrieve query string parameters
    string productId = request.QueryString["ProductID"];
    string categoryId = request.QueryString["CategoryID"];

    // fix category-product URLs
    if (productId != null && categoryId != null)
    {
      CheckCategoryProductUrl(categoryId, productId);
    }
  }

  // checks a category-product URL for compliancy
  // 301 redirects to proper URL, or returns 404 if necessary
  public static void CheckCategoryProductUrl(string categoryId, string productId)
  {
    // the current HttpContext
    HttpContext context = HttpContext.Current;

    // the URL requested by the visitor
    string requestedUrl = context.Request.ServerVariables["HTTP_X_REWRITE_URL"];

    // retrieve product and category names from fictional database
    string categoryName = SeoData.Categories[categoryId];
    string productName = SeoData.Products[productId];

    // if the category or the product doesn't exist in the database, return 404
    if (categoryName == null || productName == null)
    {
      Go404();
    }

    // obtain the standard version of the URL
    string standardUrl = LinkFactory.MakeCategoryProductUrl(categoryName, categoryId, productName, productId);

    // 301 redirect to the proper URL if necessary
    if (siteDomain + requestedUrl != standardUrl)
    {
      context.Response.Status = "301 Moved Permanently";
      context.Response.AddHeader("Location", standardUrl);
    }
  }

  // Load the 404 page
  public static void Go404()
  {
    HttpContext.Current.Server.Transfer("~/NotFound.aspx");
  }
}