<%@ Page Language="C#" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<%@ Register TagPrefix="af" Namespace="ActionlessForm" Assembly="ActionlessForm" %>

<script runat="server">
  protected void Page_Load(object sender, EventArgs e)
  {
    // display affiliate details
    HttpCookie affiliate = Request.Cookies["AffiliateID"];
    affiliateDisplay.Text = "You got here through affiliate: " + 
       ((affiliate == null) ? "(no affiliate)" : affiliate.Value);
    
    // retrieve the product ID and category ID from the query string
    string productId = Request.QueryString["ProductID"];
    string categoryId = Request.QueryString["CategoryID"];       
        
    // use productId to customize page contents
    if (productId != null && categoryId == null)
    {
      // set the page title
      this.Title += ": Product " + productId;
      
      // display product details
      message.Text =      
        String.Format("You selected product #{0}. Good choice!", productId);      
    }
    // use productId and categoryId to customize page contents
    else if (productId != null && categoryId != null)
    {
      // set the page title
      this.Title += 
        String.Format(": Product {0}: Category {1}", productId, categoryId);
      
      // display product details
      message.Text =      
        String.Format("You selected product #{0} in category #{1}. Good choice!", 
                      productId, categoryId);
    }
    else
    {
      // display product details
      message.Text = "Please select a product from our catalog.";
    }    
  }

  protected void myButton_Click(object sender, EventArgs e)
  {
    message.Text += "<br />You clicked the button!";
  }
</script>

<html xmlns="http://www.w3.org/1999/xhtml" >
<head id="Head1" runat="server">
  <title>ASP.NET SEO Shop</title>
</head>
<body>
  <af:form id="form1" runat="server">
    <asp:Literal runat="server" ID="message" />
    <asp:Button ID="myButton" runat="server" Text="Click me!" OnClick="myButton_Click" />
    <p>
      <asp:Literal runat="server" ID="affiliateDisplay" />
    </p>
  </af:form>
</body>
</html>
