<%@ WebHandler Language="C#" Class="Robots" %>
using System.Web;

public class Robots : IHttpHandler
{
  public void ProcessRequest(HttpContext context)
  {
    // get the current HttpResponse object
    HttpResponse response = context.Response;
    
    // set the proper content type
    response.ContentType = "text/plain";
    
    // add dynamic exclusion elements
    response.Write("User-agent: * \n");
    response.Write("Disallow: /Link-Juice-Print-Friendly.html \n");
    response.Write("Disallow: /Fortune-Cookie-Print-Friendly.html \n");

    // include the static exclusion data from robots_static.txt
    context.Response.WriteFile("~/robots_static.txt");

  }

  public bool IsReusable
  {
    get { return false; }
  }
}