<%@ Page Language="C#" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN"
 "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">

<script runat="server">
  // initialize siteDomain
  private string siteDomain = ConfigurationManager.AppSettings["SiteDomain"];
  
  // display navigation on page load
  protected void Page_Load(object sender, EventArgs e)
  {
    // initialize displayNav
    bool displayNav = false;

    // if there is no referer (popup was loaded directly), display navigation
    if (Request.UrlReferrer == null)
    {
      displayNav = true;
    }
    // if the REFERER is not from our domain, display navigation  
    else
    {
      string refererHost = Request.UrlReferrer.Host;
      string myHost = (new Uri(siteDomain)).Host;
      if (refererHost != myHost) displayNav = true;
    }

    // display the appropriate MultiView page
    if (displayNav) 
      navMultiView.ActiveViewIndex = 0;
    else
      navMultiView.ActiveViewIndex = 1;
  }
</script>

<html>
  <head>
    <title>Professional Search Engine Optimization with ASP.NET: Table of Contents</title>
  </head>
  <body onload="window.resizeTo(800, 600);"
        onresize='setTimeout("window.resizeTo(800, 600);", 100);'>
    <h1>Professional Search Engine Optimization with ASP.NET: Table of Contents</h1>
    <asp:Literal runat="server" ID="navigationLiteral" />

    <asp:MultiView ID="navMultiView" runat="server">
      <asp:View ID="displayNav" runat="server">
        SEOEgghead.com sells high-quality products for search engine marketers
        and web developers! <a href="<%= siteDomain %>">Visit our catalog</a>.
      </asp:View>
      <asp:View ID="noDisplayNav" runat="server">
        This is a popup window loaded from <%= siteDomain %>.
      </asp:View>
    </asp:MultiView>
    
    <ol>
      <li>You: Programmer and Search Engine Marketer</li>
      <li>A Primer in Basic SEO</li>
      <li>Provocative SE-Friendly URLs</li>
      <li>Content Relocation and HTTP Status Codes</li>
      <li>Duplicate Content</li>
      <li>SE-Friendly HTML and JavaScript</li>
      <li>Web Syndication and Social Bookmarking</li>
      <li>Black Hat SEO</li>
      <li>Sitemaps</li>
      <li>Link Bait</li>
      <li>IP Cloaking, Geo-Targeting, and IP Delivery</li>
      <li>Foreign Language SEO</li>
      <li>Coping with Technical Issues</li>
      <li>Case Study: Building an E-Commerce Catalog</li>
      <li>Site Clinic: So You Have a Web Site?</li>
      <li>Introduction to Regular Expressions</li>
    </ol>
  </body>
</html>
