using System;
using System.Collections;
using System.Collections.Generic;

/// <summary>
/// Represents a collection of Social objects
/// </summary>
public class SocialCollection : IEnumerable
{
  // we store the internal collection of Social objects as a dictionary
  private Dictionary<string, Social> socials;

  // initialize the dictionary in the constructor
  public SocialCollection()
  {
    socials = new Dictionary<string, Social>();
  }

  // indexer that allows retrieving elements by name
  public Social this[string name]
  {
    get
    {
      // all keys are lower-case
      name = name.ToLower();

      // return the Social object
      if (socials.ContainsKey(name))
        return socials[name];
      else
        throw new ArgumentException("There is no social site named " + name);
    }
  }

  // create a new Social object and Add(it to the collection
  public void Add(string name, string imageFile, string url)
  {
    // make sure the name is all lower-case
    name = name.ToLower();

    // Add(the Social object to the collection
    if (!socials.ContainsKey(name))
    {
      // create a new Social object
      Social social = new Social(name, imageFile, url);

      // add the new object to the collection
      socials.Add(name, social);
    }
    else
      throw new ArgumentException("The object already exists: " + name);
  }

  // Add(a Social object to the collection
  public void Add(Social social)
  {
    // Add(the Social object to the collection
    if (!socials.ContainsKey(social.Name.ToLower()))
      socials.Add(social.Name.ToLower(), social);
    else
      throw new ArgumentException("The object already exists: " + social.Name);
  }

  // infractructure code that implements IEnumerable
  IEnumerator IEnumerable.GetEnumerator()
  {
    return socials.Values.GetEnumerator();
  }
}