<%@ WebHandler Language="C#" Class="BooksFeed" %>

using System;
using System.Web;
using RssToolkit;

// Class that generates the RSS feed
public class BooksFeed : GenericRssHttpHandlerBase 
{
  protected override void PopulateChannel(string channelName, string userName)
  {
    // set channel details; see http://blogs.law.harvard.edu/tech/rss 
    Channel["title"] = "Forthcoming Titles by Cristian Darie";
    Channel["link"] = "http://www.cristiandarie.ro/forthcoming/";
    Channel["description"] = "Details about Cristian's forthcoming titles, updated monthly";
    Channel["ttl"] = "10000"; // how many minutes the content should be cached

    // generic RSS element
    GenericRssElement item;

    // add RSS item
    item = new GenericRssElement();
    item["title"] = "Microsoft ASP.NET AJAX Essentials";
    item["description"] = "Step by step tutorial for creating Web 2.0 applications using the Microsoft AJAX Library, and the ASP.NET AJAX Extensions.";
    item["link"] = "http://www.cristiandarie.ro/microsoft-ajax-1/";
    Channel.Items.Add(item);

    // add RSS item
    item = new GenericRssElement();
    item["title"] = "Beginning PHP and MySQL E-Commerce, Second Edition";
    item["description"] = "Friendly tutorial for creating a functional online catalog, from design to deployment. New features in this new edition include SEO enhancements, product attributes, AJAX-enabled functionality, and more.";
    item["link"] = "http://www.cristiandarie.ro/php-mysql-ecommerce-2/";
    Channel.Items.Add(item);

    // add RSS item
    item = new GenericRssElement();
    item["title"] = "Mysterious Book";
    item["description"] = "Mysterious title about the complexity of life demonstrates that the answer to Life, the Universe and Everything is NOT 42.";
    item["link"] = "http://www.cristiandarie.ro/mystery/";
    Channel.Items.Add(item);

    // add RSS item
    item = new GenericRssElement();
    item["title"] = "A Million Random Digits with 100,000 Normal Deviates";
    item["description"] = "This book is neither forcoming, nor written by Cristian Darie, but he surely wishes he had the idea first.";
    item["link"] = "http://www.amazon.com/dp/0833030477/";
    Channel.Items.Add(item);
  }
}