<%@ WebHandler Language="C#" Class="Handler" %>

using System;
using System.Web;
using System.Text;
using System.Xml;

public class Handler : IHttpHandler 
{    
  public void ProcessRequest (HttpContext context) 
  {
    // get the HttpResponse object for the current request
    HttpResponse response = context.Response;
    
    // set the content type
    response.ContentType = "text/xml";
    
    // create XmlTextWriter object  
    XmlTextWriter xmlWriter = new XmlTextWriter(response.OutputStream, Encoding.UTF8);
    
    // start the RSS feed and generate channel data elements
    xmlWriter.WriteStartDocument();
    xmlWriter.WriteStartElement("rss");
    xmlWriter.WriteAttributeString("version", "2.0");
    xmlWriter.WriteStartElement("channel");
    xmlWriter.WriteElementString("title", "Forthcoming Titles by Cristian Darie");
    xmlWriter.WriteElementString("link", "http://www.cristiandarie.ro/forthcoming/");
    xmlWriter.WriteElementString("description", "Details about Cristian's forthcoming titles, updated monthly");
    xmlWriter.WriteElementString("ttl", "10000");
    
    // generate RSS item
    xmlWriter.WriteStartElement("item");
    xmlWriter.WriteElementString("title", "Microsoft ASP.NET AJAX Essentials");
    xmlWriter.WriteElementString("description", "Step by step tutorial for creating Web 2.0 applications using the Microsoft AJAX Library, and the ASP.NET AJAX Extensions.");
    xmlWriter.WriteElementString("link", "http://www.cristiandarie.ro/microsoft-ajax-1/");
    xmlWriter.WriteEndElement();
    
    // close feed
    xmlWriter.WriteEndElement();
    xmlWriter.WriteEndElement();
    xmlWriter.WriteEndDocument();
    xmlWriter.Flush();
    xmlWriter.Close();
    response.End();
  }

  public bool IsReusable 
  {
    get 
    {
      return false;
    }
  }
}