<%@ Control Language="C#" ClassName="SocialIcons" %>

<link href="seoasp.css" type="text/css" rel="stylesheet" />

<asp:Repeater runat="server" ID="socialIconsRepeater">
  <HeaderTemplate>
    <ul id="social">
  </HeaderTemplate>
  <ItemTemplate>
    <li>
      <a rel="nofollow" href="<%# Eval("Url") %>" title="<%# Eval("Name") %>">
        <img src="social_icons/<%# Eval("ImageFile") %>" alt="<%# Eval("Name") %>" />
      </a>
    </li>
  </ItemTemplate>
  <FooterTemplate>
    </ul>
  </FooterTemplate>
</asp:Repeater>

<script runat="server">
  // the list with social bookmarking services
  private readonly static SocialCollection allSocials;
  
  // the list with services we need to generate links for
  private string[] socialSiteNames;
  
  // link and title of the page we're bookmarking
  private string myPageLink, myPageTitle;

  // public properties
  public string MyPageLink
  {
    set { myPageLink = value; }
  }
  
  public string MyPageTitle
  {
    set { myPageTitle = value; }
  }

  public string SocialSiteNames
  {
    set 
    { 
      socialSiteNames = value.Split(new char[] { ',' }, 
        StringSplitOptions.RemoveEmptyEntries); 
    }
  }
    
  protected void Page_Load(object sender, EventArgs e)
  {
    // continue only if the control has been properly initialized
    if (myPageLink == null || myPageTitle == null ||
        socialSiteNames == null || socialSiteNames.Length == 0)
    {
      throw new Exception("The SocialBookmarkIcons control requires you to provide values for its properties: MyPageLink, MyPageTitle, and SocialSiteNames.");
    }
      
    // create the collection object
    SocialCollection socials = new SocialCollection();

    // built the collection of Social object
    foreach (string socialName in socialSiteNames)
    {
      Social newSocial = allSocials[socialName];
      newSocial.Url = newSocial.Url.Replace("{LINK}", HttpUtility.UrlEncode(myPageLink));
      newSocial.Url = newSocial.Url.Replace("{TITLE}", HttpUtility.UrlEncode(myPageTitle));
      socials.Add(newSocial);
    }

    // bind the social icons data to the repeater
    socialIconsRepeater.DataSource = socials;
    socialIconsRepeater.DataBind();
  }
    
  static SocialIcons()
  {
    // populate the collection of social bookmarking sites
    allSocials = new SocialCollection();
    allSocials.Add("BlinkBits", "blinkbits.png", "http://www.blinkbits.com/bookmarklets/save.php?v=1&source_url={LINK}&title={TITLE}&body={TITLE}");
    allSocials.Add("BlinkList", "blinklist.png", "http://www.blinklist.com/index.php?Action=Blink/addblink.php&Description=&Url={LINK}&Title={TITLE}");
    allSocials.Add("Blogmarks", "blogmarks.png", "http://blogmarks.net/my/new.php?mini=1&simple=1&url={LINK}&title={TITLE}");
    allSocials.Add("co.mments", "co.mments.gif", "http://co.mments.com/track?url={LINK}&title={TITLE}");
    allSocials.Add("connotea", "connotea.png", "http://www.connotea.org/addpopup?continue=confirm&uri={LINK}&title={TITLE}");
    allSocials.Add("del.icio.us", "delicious.png", "http://del.icio.us/post?url={LINK}&title={TITLE}");
    allSocials.Add("De.lirio.us", "delirious.png", "http://de.lirio.us/rubric/post?uri={LINK}&title={TITLE};when_done=go_back");
    allSocials.Add("Digg", "digg.png", "http://digg.com/submit?phase=2&url={LINK}&title={TITLE}");
    allSocials.Add("FeedMeLinks", "feedmelinks.png", "http://feedmelinks.com/categorize?from=toolbar&op=submit&url={LINK}&name={TITLE}");
    allSocials.Add("Furl", "furl.png", "http://www.furl.net/storeIt.jsp?u={LINK}&t={TITLE}");
    allSocials.Add("LinkaGoGo", "linkagogo.png", "http://www.linkagogo.com/go/AddNoPopup?url={LINK}&title={TITLE}");
    allSocials.Add("Ma.gnolia", "magnolia.png", "http://ma.gnolia.com/beta/bookmarklet/add?url={LINK}&title={TITLE}&description={TITLE}");
    allSocials.Add("NewsVine", "newsvine.png", "http://www.newsvine.com/_tools/seed&save?u={LINK}&h={TITLE}");
    allSocials.Add("Netvouz", "netvouz.png", "http://www.netvouz.com/action/submitBookmark?url={LINK}&title={TITLE}&description={TITLE}");
    allSocials.Add("Reddit", "reddit.png", "http://reddit.com/submit?url={LINK}&title={TITLE}");
    allSocials.Add("scuttle", "scuttle.png", "http://www.scuttle.org/bookmarks.php/maxpower?action=add&address={LINK}&title={TITLE}&description={TITLE}");
    allSocials.Add("Shadows", "shadows.png", "http://www.shadows.com/features/tcr.htm?url={LINK}&title={TITLE}");
    allSocials.Add("Simpy", "simpy.png", "http://www.simpy.com/simpy/LinkAdd.do?href={LINK}&title={TITLE}");
    allSocials.Add("Smarking", "smarking.png", "http://smarking.com/editbookmark/?url={LINK}&description={TITLE}");
    allSocials.Add("Spurl", "spurl.png", "http://www.spurl.net/spurl.php?url={LINK}&title={TITLE}");
    allSocials.Add("TailRank", "tailrank.png", "http://tailrank.com/share/?text=&link_href={LINK}&title={TITLE}");
    allSocials.Add("Wists", "wists.png", "http://wists.com/r.php?c=&r={LINK}&title={TITLE}");
    allSocials.Add("YahooMyWeb", "yahoomyweb.png", "http://myweb2.search.yahoo.com/myresults/bookmarklet?u={LINK}&t={TITLE}");
  }
</script>
