<%@ Page Language="C#" %>
<%@ Register Src="UserControls/SimpleCaptcha.ascx" TagName="SimpleCaptcha" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<script runat="server">
  // submit comment when visitor clicks the Submit button
  protected void submitButton_Click(object sender, EventArgs e)
  {
    // continue only if there is the visitor typed a comment
    if (commentTextBox.Text.Trim() == "")
    {
      feedbackLabel.Text = "Please write a comment.";
    }
    else if (!simpleCaptcha.CheckAnswer())
    {
      feedbackLabel.Text = "Wrong answer!";
    }
    else
    {
      feedbackLabel.Text = "Thank you for your comment!";
      commentTextBox.Text = "";
      // ... code that adds the comment to the database ...
    }
  }
</script>

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
  <title>Professional Search Engine Optimization with ASP.NET</title>
</head>
<body>
  <form id="Form1" runat="server">
    <h1>Captcha Testing</h1>
    <p>
      Enter a comment:
      <br />
      <asp:TextBox ID="commentTextBox" Width="400" Rows="5" 
                   TextMode="MultiLine" runat="server" />
    </p>
    <p>
      <uc1:SimpleCaptcha ID="simpleCaptcha" runat="server" />
    </p>
    <p>
      <asp:Button ID="submitButton" runat="server" 
                  Text="Submit Comment" OnClick="submitButton_Click" />
    </p>
    <p>
      <asp:Label ForeColor="Red" ID="feedbackLabel" runat="server" />
    </p>
  </form>
</body>
</html>
