using System;
using System.Web;
using System.Web.Security;
using System.Web.Configuration;

public partial class UserControls_SimpleCaptcha : System.Web.UI.UserControl
{
  // define array with known numbers
  private static string[] numbers = 
    { "Zero", "One", "Two", "Three", "Four", "Five", "Six", 
      "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", 
      "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", 
      "Eighteen", "Nineteen", "Twenty" };

  // define possible question formats
  private static string[] questions = 
    { "What is {0} plus {1}?",
      "What is the sum of {0} and {1}?", 
      "What is {0} added to {1}?",
      "What is {0} + {1}?" };

  // display the captcha question when the page is loaded
  protected void Page_Load(object sender, EventArgs e)
  {
    // Don't regenerate the question on postbacks
    if (!IsPostBack)
    {
      displayQuestion();
    }
  }

  // return true if the supplied answer is correct, or false otherwise
  public bool CheckAnswer()
  {
    // retrieve answer and the hash of the correct answer
    string answer = captchaAnswerTextBox.Text;
    string correctAnswerHash = correctAnswerHidden.Value;

    // calculate the hash of the answer
    answer = answer.Trim() + HttpContext.Current.Request.UserHostAddress;
    string answerHash =
      FormsAuthentication.HashPasswordForStoringInConfigFile(answer, "md5");

    // display new question
    displayQuestion();

    // indicate if the answer was correct
    return (answerHash == correctAnswerHash);
  }

  private void displayQuestion()
  {
    // generate random numbers and question
    Random random = new Random();
    int number_1 = random.Next(numbers.Length);
    int number_2 = random.Next(numbers.Length);
    int question_no = random.Next(questions.Length);

    // build the question 
    string question = String.Format(questions[question_no],
                                    numbers[number_1], numbers[number_2]);

    // calculate the answer, add the visitor's IP, and calculate the hash
    string answer = (number_1 + number_2).ToString();
    answer += HttpContext.Current.Request.UserHostAddress;
    string answerHash =
      FormsAuthentication.HashPasswordForStoringInConfigFile(answer, "md5");

    // save the hash of the correct answer and populate the form
    correctAnswerHidden.Value = answerHash;
    captchaLabel.Text = question;
    captchaAnswerTextBox.Text = "";
  }
}
