<%@ WebHandler Language="C#" Class="Sitemap" %>

using System;
using System.Web;
using System.Xml;
using System.Configuration;
using System.Collections;

public class Sitemap : IHttpHandler
{
  // structure that represents a sitemap item
  struct SitemapItem
  {
    // public fields representing the sitemap item properties
    public string Url, LastMod, ChangeFreq, Priority;
    
    // constructor initializes the fields
    public SitemapItem(string url, string lastMod, string changeFreq, string priority)
    {
      this.Url = url;
      this.LastMod = lastMod;
      this.ChangeFreq = changeFreq;
      this.Priority = priority;
    }
  }

  // the entry-point method called when the handler is loaded 
  public void ProcessRequest(HttpContext context)
  {
    // retrieve the value of the Target parameter
    string target = context.Request.QueryString["Target"];
    
    // if there is no target, quit
    if (target == null) return;
    
    // generate the requested sitemap
    if (target.ToLower() == "google")
    {
      GenerateGoogleSitemap();
    }
    else if (target.ToLower() == "yahoo")
    {
      GenerateYahooSitemap();
    }
  }
  
  // generates the Google sitemap of the site
  private void GenerateGoogleSitemap()
  {
    // obtain the current HttpResponse object
    HttpResponse response = HttpContext.Current.Response;

    // set the content type
    response.ContentType = "text/xml";
    
    // use an XmlWriter to generate the Google sitemap
    XmlWriter xmlWriter = XmlWriter.Create(response.OutputStream);

    // write the start element
    xmlWriter.WriteStartElement("urlset", "http://www.google.com/schemas/sitemap/0.84");

    // obtain the list of sitemap items
    ArrayList sitemapItems = GetSitemapItems();

    // generate the sitemap items
    foreach (SitemapItem sitemapItem in sitemapItems)
    {
      // generate the <url> element and its contents
      xmlWriter.WriteStartElement("url");
      xmlWriter.WriteElementString("loc", sitemapItem.Url);
      xmlWriter.WriteElementString("lastmod", sitemapItem.LastMod);
      xmlWriter.WriteElementString("changefreq", sitemapItem.ChangeFreq);
      xmlWriter.WriteElementString("priority", sitemapItem.Priority);
      xmlWriter.WriteEndElement();
    }

    // close the document 
    xmlWriter.WriteEndElement();    
    xmlWriter.Flush();
  }

  // generates the Yahoo sitemap of the site
  private void GenerateYahooSitemap()
  {
    // obtain the current HttpResponse object
    HttpResponse response = HttpContext.Current.Response;

    // set the content type
    response.ContentType = "text/plain";

    // obtain the list of sitemap items
    ArrayList sitemapItems = GetSitemapItems();

    // generate the sitemap items
    foreach (SitemapItem sitemapItem in sitemapItems)
    {
      response.Write(sitemapItem.Url + "\n");
    }
  }

  // builds the list of items that need to be included in the sitemap
  private ArrayList GetSitemapItems()
  {
    // declare list of sitemap items
    //List<SitemapItem> sitemapItems = new List<SitemapItem>();
    //List<SitemapItem> sitemapItems = new List<SitemapItem>();
    ArrayList sitemapItems = new ArrayList();

    // create the list of URLs to include in the sitemap
    sitemapItems.Add(new SitemapItem(
      ConfigurationManager.AppSettings["SiteDomain"] + "/Catalog.html",
      "2007/05/05", "daily", "0.3"));

    sitemapItems.Add(new SitemapItem(
      LinkFactory.MakeCategoryProductUrl(SeoData.Categories["12"], 12,
      SeoData.Products["45"], 45), "2007/05/05", "weekly", "0.6"));

    sitemapItems.Add(new SitemapItem(
      LinkFactory.MakeCategoryProductUrl(SeoData.Categories["2"], 2,
      SeoData.Products["42"], 42), "2007/05/05", "weekly", "0.6"));

    sitemapItems.Add(new SitemapItem(
      LinkFactory.MakeCategoryProductUrl(SeoData.Categories["6"], 6,
      SeoData.Products["15"], 15), "2007/05/05", "weekly", "0.6"));

    sitemapItems.Add(new SitemapItem(
      LinkFactory.MakeCategoryProductUrl(SeoData.Categories["6"], 6,
      SeoData.Products["31"], 31), "2007/05/05", "weekly", "0.6"));
    
    // return the list of Sitemap objects
    return sitemapItems;
  } 

  public bool IsReusable
  {
    get
    {
      return false;
    }
  }
}