<%@ WebHandler Language="C#" Class="FortuneCookie" %>

using System;
using System.Web;
using System.Drawing;
using System.Drawing.Imaging;

// generates a random fortune cookie image
public class FortuneCookie : IHttpHandler
{
  public void ProcessRequest(HttpContext context)
  {
    // Define the possible fortune messages
    string[] fortunes = {"Jaimie Sirovich will become your\r\nfavorite author.",
      "You will recommend this book to\r\nall your friends.",
      "Tomorrow you will make \r\nyour first million.",
      "You will read Microsoft \r\nAJAX Library Essentials"};

    // Get a random fortune message
    Random randomGenerator = new Random();
    string fortuneMessage = fortunes[randomGenerator.Next(fortunes.Length)];

    // Load the empty fortune cookie image
    string imageLocation = context.Server.MapPath("/Images/fortune_cookie.gif");
    Bitmap emptyCookieBitmap = new Bitmap(imageLocation);

    // Create the new fortune cookie image
    Bitmap fortuneCookieBitmap =
      new Bitmap(emptyCookieBitmap.Width, emptyCookieBitmap.Height);

    // Create a Graphics object, and use it to draw the cookie to the new image
    Graphics gr = Graphics.FromImage(fortuneCookieBitmap);
    gr.DrawImage(emptyCookieBitmap, 0, 0);

    // Draw the fortune text on the new cookie image
    Font messageFont = new Font("Comic Sans MS", 10, FontStyle.Bold);
    gr.DrawString(fortuneMessage, messageFont, Brushes.Black, 130, 48);

    // Output the image and clear the Graphics object
    context.Response.Clear();
    context.Response.ContentType = "image/jpeg";
    fortuneCookieBitmap.Save(context.Response.OutputStream, ImageFormat.Jpeg);
    gr.Dispose();
  }

  public bool IsReusable
  {
    get
    {
      return true;
    }
  }
}