using System;
using System.Web;

/// <summary>
/// Summary description for GeoTarget
/// </summary>
public class GeoTarget
{
  // returns the region code of the current visitor
  public static string GetRegionCode()
  {
    string visitorIp = HttpContext.Current.Request["REMOTE_ADDR"];
    return GetRegionCode(visitorIp);
  }

  // returns the region code of the IP
  public static string GetRegionCode(string ip)
  {
    string[] ipp = ip.Split(new char[] { '.' });

    long longIp = 16777216 * long.Parse(ipp[0]) + 65536 * long.Parse(ipp[1]) +
                  256 * long.Parse(ipp[2]) + long.Parse(ipp[3]);

    return GeoTargetDb.GetRegion(longIp);
  }

  // verifies if the current visitor is from the specified region
  public static bool IsRegionCode(string regionCode)
  {
    return (GetRegionCode() == regionCode);
  }

  // verifies if the provided IP is from the specified region
  public static bool IsRegionCode(string regionCode, string ip)
  {
    return (GetRegionCode(ip) == regionCode);
  }
}