<%@ Page Language="C#" %>
<%@ Import Namespace="System.Net" %>
<%@ Import Namespace="System.Text" %>
<%@ Import Namespace="System.IO" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<script runat="server">
  protected void Page_Load(object sender, EventArgs e)
  {
    // the URL to start from
    string url = "http://www.cristiandarie.ro/seophp.aspx";

    // request object
    HttpWebRequest request;
    
    // start by assuming that the provided URL is the final URL
    bool reachedDestination = true;
    
    // don't make more than this number of requests
    int maxRequests = 10;

    // display data about one request at each iteration
    do
    {
      // initialize the destination location to null
      string location = null;

      // try to read data from the URL
      try
      {      
        // make a HTTP request, without allowing autoredirects
        request = (HttpWebRequest)HttpWebRequest.Create(url);
        request.AllowAutoRedirect = false;
      
        // display the URL we're trying to reach
        myOutput.Text += "URL: " + url;

        // retrieve the contents 
        HttpWebResponse linkResponse = (HttpWebResponse)request.GetResponse();

        // retrieve the location
        location = linkResponse.Headers["Location"];

        // display data about the URL
        string output = "";
        output += "<p>Server: " + linkResponse.Server;
        output += "<br />Content type: " + linkResponse.ContentType;
        output += "<br />Content length: " + linkResponse.ContentLength;
        output += "<br />Status code: " + (int)linkResponse.StatusCode;
        output += "<br />Status description: " + linkResponse.StatusDescription;
        if (location != null)
          output += "<br />Destination: " + location + "</p>";
        myOutput.Text += output;
      }
      catch (Exception ex)
      {
        myOutput.Text += "<br />Error: " + ex.Message;
      }

      // decide if another iteration is necessary
      if (location != null)
      {
        url = location;
        reachedDestination = false;
      }
      else
        reachedDestination = true;

      // count down to maximum number of requests
      maxRequests--;
    }
    // continue the loop until we reach the destination or reach the maximum 
    // allowed number of requests
    while (!reachedDestination && maxRequests > 0);
  }
</script>

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
  <title>Link Checker Test</title>
</head>
<body>
  <form id="form1" runat="server">
    <div>
      <asp:Literal runat="server" ID="myOutput" />
    </div>
  </form>
</body>
</html>
