using System;
using System.Web;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;

/// <summary>
/// Summary description for GeoTargetDb
/// </summary>
public class CatalogDb
{
  // retrieves the details of o brand
  public static DataRow GetBrand(string brandId)
  {
    // create a SqlCommand object with a connection to the cloak database
    SqlCommand command = createCommand("ProductsDatabase");

    // set the name of the stored procedure to execute
    command.CommandText = "GetBrand";

    // @BrandID
    SqlParameter p = new SqlParameter("@BrandID", brandId);
    command.Parameters.Add(p);

    // create a new DataTable object
    DataTable results = new DataTable();

    // execute the stored procecure and load the results into the DataTable
    command.Connection.Open();
    try { results.Load(command.ExecuteReader()); }
    finally { command.Connection.Close(); }

    // return a DataRow containing the category details
    return (results.Rows.Count > 0) ? results.Rows[0] : null;
  }

  // retrieves all categories
  public static DataTable GetCategories()
  {
    // create a SqlCommand object with a connection to the cloak database
    SqlCommand command = createCommand("ProductsDatabase");

    // set the name of the stored procedure to execute
    command.CommandText = "GetCategories";

    // create a new DataTable object
    DataTable results = new DataTable();

    // execute the stored procecure and load the results into the DataTable
    command.Connection.Open();
    try { results.Load(command.ExecuteReader()); }
    finally { command.Connection.Close(); }

    // return the results 
    return results;
  }

  // retrieves the details of a category
  public static DataRow GetCategory(string categoryId)
  {
    // create a SqlCommand object with a connection to the cloak database
    SqlCommand command = createCommand("ProductsDatabase");

    // set the name of the stored procedure to execute
    command.CommandText = "GetCategory";

    // @CategoryID
    SqlParameter p = new SqlParameter("@CategoryID", categoryId);
    command.Parameters.Add(p);

    // create a new DataTable object
    DataTable results = new DataTable();

    // execute the stored procecure and load the results into the DataTable
    command.Connection.Open();
    try { results.Load(command.ExecuteReader()); }
    finally { command.Connection.Close(); }

    // return a DataRow containing the category details
    return (results.Rows.Count > 0) ? results.Rows[0] : null;
  }

  // retrieves a page of products from a category
  public static DataTable GetProductsInCategory(string categoryId, int pageNumber, out int howManyPages)
  {
    // create a SqlCommand object with a connection to the cloak database
    SqlCommand command = createCommand("ProductsDatabase");

    // set the name of the stored procedure to execute
    command.CommandText = "GetProductsInCategory";

    // @CategoryID
    SqlParameter p = new SqlParameter("@CategoryID", categoryId);
    command.Parameters.Add(p);

    // @PageNumber
    p = new SqlParameter("@PageNumber", pageNumber);
    command.Parameters.Add(p);

    // @PageNumber
    p = new SqlParameter("@ProductsPerPage", 
      ConfigurationManager.AppSettings["ProductsPerPage"]);
    command.Parameters.Add(p);

    // @HowManyPages
    p = new SqlParameter("@HowManyProducts", SqlDbType.Int);
    p.Direction = ParameterDirection.Output;
    command.Parameters.Add(p);

    // create a new DataTable object
    DataTable results = new DataTable();

    // execute the stored procecure and load the results into the DataTable
    command.Connection.Open();
    try { results.Load(command.ExecuteReader()); }
    finally { command.Connection.Close(); }

    // return the number of product pages as an out parameter
    int howManyProducts = Int32.Parse(command.Parameters["@HowManyProducts"].Value.ToString());
    howManyPages = (int)Math.Ceiling((double)howManyProducts /
                   double.Parse(ConfigurationManager.AppSettings["ProductsPerPage"]));

    // return the results 
    return results;
  }

  // retrieves the details of one product
  public static DataRow GetProduct(string productId)
  {
    // create a SqlCommand object with a connection to the cloak database
    SqlCommand command = createCommand("ProductsDatabase");

    // set the name of the stored procedure to execute
    command.CommandText = "GetProduct";

    // @CategoryID
    SqlParameter p = new SqlParameter("@ProductID", productId);
    command.Parameters.Add(p);

    // create a new DataTable object
    DataTable results = new DataTable();

    // execute the stored procecure and load the results into the DataTable
    command.Connection.Open();
    try { results.Load(command.ExecuteReader()); }
    finally { command.Connection.Close(); }

    // return a DataRow containing the product details
    return (results.Rows.Count > 0) ? results.Rows[0] : null;
  }

  // retrieves the products with secondary categories for robots.txt exclusion
  public static DataTable GetSecondaryProductCategories()
  {
    // create a SqlCommand object with a connection to the cloak database
    SqlCommand command = createCommand("ProductsDatabase");

    // set the name of the stored procedure to execute
    command.CommandText = "GetSecondaryProductCategories";

    // create a new DataTable object
    DataTable results = new DataTable();

    // execute the stored procecure and load the results into the DataTable
    command.Connection.Open();
    try { results.Load(command.ExecuteReader()); }
    finally { command.Connection.Close(); }

    // return the results 
    return results;
  }

  // creates and prepares a new SqlCommand object on a new connection
  private static SqlCommand createCommand(string connectionName)
  {
    // obtain the database connection string
    string connectionString = ConfigurationManager.ConnectionStrings[connectionName].ConnectionString;

    // obtain a database specific connection object
    SqlConnection conn = new SqlConnection(connectionString);

    // create a database specific command object
    SqlCommand comm = conn.CreateCommand();

    // set the command type to stored procedure
    comm.CommandType = CommandType.StoredProcedure;

    // return the initialized command object
    return comm;
  }
}