using System;
using System.Web;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;

/// <summary>
/// Summary description for GeoTargetDb
/// </summary>
public class GeoTargetDb
{
  public static string GetRegion(long longIp)
  {
    // create a SqlCommand object with a connection to the cloak database
    SqlCommand command = createCommand("GeoTargetDatabase");

    // set the name of the stored procedure to execute
    command.CommandText = "GeoTargetGetRegion";

    // @IP
    SqlParameter p = new SqlParameter("@IP", longIp);
    command.Parameters.Add(p);

    // execute the stored procedure
    command.Connection.Open();    
    string countryCode;

    try { countryCode = command.ExecuteScalar().ToString(); }
    catch { countryCode = ""; }
    finally { command.Connection.Close(); }
    
    // return the country code
    return countryCode;
  }

  // Creates and prepares a new SqlCommand object on a new connection
  private static SqlCommand createCommand(string connectionName)
  {
    // obtain the database connection string
    string connectionString = ConfigurationManager.ConnectionStrings[connectionName].ConnectionString;

    // obtain a database specific connection object
    SqlConnection conn = new SqlConnection(connectionString);

    // create a database specific command object
    SqlCommand comm = conn.CreateCommand();

    // set the command type to stored procedure
    comm.CommandType = CommandType.StoredProcedure;

    // return the initialized command object
    return comm;
  }
}