<%@ Page Language="C#" EnableViewState="false" %>
<%@ Import Namespace="System.Data" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<script runat="server">
  // product attributes are stored as private fields
  private string categoryId;
  private string categoryName;
  private int page;
  private int howManyPages;

  // fill the form with data
  protected void Page_Load(object sender, EventArgs e)
  {
    // get category ID
    categoryId = Request.QueryString["CategoryID"];

    // obtain category name 
    DataRow categoryRow = CatalogDb.GetCategory(categoryId);
    categoryName = categoryRow["Name"].ToString();

    // what page?
    string pageString = Request.QueryString["Page"];
    page = (pageString == null) ? 1 : int.Parse(pageString);

    // display the category products and get the number of pages
    productsRepeater.DataSource = CatalogDb.GetProductsInCategory(categoryId, page, out howManyPages);
    productsRepeater.DataBind();
    
    // of the total number of pages is lower than the requested page, send 404
    if (page > howManyPages)
    {
      UrlTools.NotFound();
    }

    // create an ArrayList with the page numbers 
    ArrayList pageNumbers = new ArrayList();
    for (int i = 1; i <= howManyPages; i++) pageNumbers.Add(i);

    // bind the pager repeater to the page numbers array
    pagerRepeater.DataSource = pageNumbers;
    pagerRepeater.DataBind();
  }
</script>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
  <title><%= categoryName %> - Cookie Ogre's Warehouse</title>
</head>
<body>
  <form id="form1" runat="server">
    <h1>
      <%= categoryName %> - 
      <a href="<%= UrlTools.SiteDomain %>">Cookie Ogre's Warehouse</a>
    </h1>
    <p>
      We have a delightful collection <b><%= categoryName %></b> cookies!
    </p>
    
    <!-- Repeater control displays the products list -->
    <asp:Repeater ID="productsRepeater" runat="server">
      <HeaderTemplate>
        <ul>
      </HeaderTemplate>
      <ItemTemplate>
        <li>
          <a href="<%# LinkFactory.MakeCategoryProductUrl(categoryName, categoryId, Eval("Name").ToString(), Eval("ID").ToString()) %>">
            <%# Eval("Name") %>
          </a>
        </li>
      </ItemTemplate>
      <FooterTemplate>
        </ul>
      </FooterTemplate>
    </asp:Repeater>
    
    <!-- Repeater control displays pager links -->
    <asp:Repeater ID="pagerRepeater" runat="server">
      <HeaderTemplate>
        <asp:HyperLink ID="h2" runat="server" Text="<< previous" 
          NavigateUrl='<%# LinkFactory.MakeCategoryUrl(categoryName, categoryId, page - 1) %>'
          Enabled='<%# page > 1 %>' /> |
      </HeaderTemplate>
      <ItemTemplate>
        <asp:HyperLink ID="h3" runat="server" Text='<%# Container.DataItem %>' 
          NavigateUrl='<%# LinkFactory.MakeCategoryUrl(categoryName, categoryId, (int)Container.DataItem) %>'
          Enabled='<%# page != (int)Container.DataItem %>' /> |
      </ItemTemplate>
      <FooterTemplate>
        <asp:HyperLink ID="h2" runat="server" Text="next >>" 
          NavigateUrl='<%# LinkFactory.MakeCategoryUrl(categoryName, categoryId, page + 1) %>'
          Enabled='<%# page < howManyPages %>' />
      </FooterTemplate>
    </asp:Repeater>
  </form>
</body>
</html>