<%@ Application Language="C#" %>
<%@ Import Namespace="System.Net" %>
<%@ Import Namespace="System.Net.Mail" %>
<%@ Import Namespace="System.Configuration" %>

<script RunAt="server">

  void Application_BeginRequest(object sender, EventArgs e)
  {
    // ensures a standard URL is used, 301 redirect to it otherwise
    UrlTools.CheckUrl();
  }
  
  void Application_EndRequest(object sender, EventArgs e)
  {
    // ensures a standard URL is used, 301 redirect to it otherwise

    //Context.RewritePath("/?");
    
  }
  
  
  
  
  void Application_Start(object sender, EventArgs e)
  {
    // Code that runs on application startup

  }

  void Application_End(object sender, EventArgs e)
  {
    //  Code that runs on application shutdown

  }

  // email the error details when an unhandled exception is raised
  void Application_Error(Object sender, EventArgs e)
  {
    // get the exception details    
    Exception ex = Server.GetLastError();
    if (ex.InnerException != null) ex = ex.InnerException;

    // get the current date and time
    string dateTime = DateTime.Now.ToLongDateString() + ", at "
                    + DateTime.Now.ToShortTimeString();

    // build the error message
    string errorMessage = "Exception generated on " + dateTime;
    System.Web.HttpContext context = System.Web.HttpContext.Current;
    errorMessage += "\n\n Page location: " + context.Request.RawUrl;
    errorMessage += "\n\n Message: " + ex.Message;
    errorMessage += "\n\n Source: " + ex.Source;
    errorMessage += "\n\n Method: " + ex.TargetSite;
    errorMessage += "\n\n Stack Trace: \n\n" + ex.StackTrace;

    // email the error details
    string mailServer = ConfigurationManager.AppSettings["EmailServer"];
    string from = ConfigurationManager.AppSettings["ErrorEmailFrom"];
    string to = ConfigurationManager.AppSettings["ErrorEmailTo"];
    string smtpUser = ConfigurationManager.AppSettings["SmtpHostUserName"];
    string smtpPassword = ConfigurationManager.AppSettings["SmtpHostPassword"];

    string subject = "Example.com error report";
    try
    {
      SmtpClient mailClient = new SmtpClient(mailServer);
      MailMessage mailMessage = new MailMessage(from, to, subject, errorMessage);
      mailClient.Credentials = new NetworkCredential(smtpUser, smtpPassword);
      mailClient.Send(mailMessage);
    }
    catch (Exception myex) {  } 
  }

  void Session_Start(object sender, EventArgs e)
  {

  }

  void Session_End(object sender, EventArgs e)
  {
    // Code that runs when a session ends. 
    // Note: The Session_End event is raised only when the sessionstate mode
    // is set to InProc in the Web.config file. If session mode is set to StateServer 
    // or SQLServer, the event is not raised.

  }
       
</script>

