<%@ Page Language="C#" EnableViewState="False" %>
<%@ Import Namespace="System.Data" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<script runat="server">
  // product attributes are stored as private fields
  private string productId, productName, productDescription;
  private decimal productPrice;
  private string brandId, brandName;  
  private string primaryCategoryId, primaryCategoryName;

  // fill the form with product data
  protected void Page_Load(object sender, EventArgs e)
  {     
    // get product ID
    productId = Request.QueryString["ProductID"];

    // obtain product details or send 404 if product doesn't exist
    DataRow productRow = CatalogDb.GetProduct(productId);
    if (productRow == null)
    {
      UrlTools.NotFound();
      return;
    }
    else
    {
      // read product details from the DataRow
      productName = productRow["Name"].ToString();      
      productPrice = decimal.Parse(productRow["Price"].ToString());
      productDescription = productRow["Description"].ToString();
      primaryCategoryId = productRow["PrimaryCategoryID"].ToString();
      brandId = productRow["BrandID"].ToString();
      
      // obtain the brand name 
      brandName = CatalogDb.GetBrand(brandId)["Name"].ToString();
      
      // obtain the primary category name 
      primaryCategoryName = CatalogDb.GetCategory(primaryCategoryId)["Name"].ToString();

      // required to support PostBack events in the page
      Context.RewritePath("/?");
    }
  }

  protected void addToCartButton_Click(object sender, EventArgs e)
  {
    cartLabel.Text = "The product was added to your shopping cart!";
  }
</script>

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
  <title><%= productName %> - Cookie Ogre Warehouse</title>
</head>
<body>
  <form id="form1" runat="server">
    <!-- Display title, which includes link to the home page -->
    <h1>
      <%= productName %> - 
      <a href="<%= UrlTools.SiteDomain %>">Cookie Ogre's Warehouse</a>
    </h1>

    <!-- Display the product description -->    
    <p><%= productDescription %></p>
    
    <!-- Display the brand name and logo -->    
    <p>This cookie is brought to you by <b><%= brandName %></b>.</p>
    <p><img src="<%= LinkFactory.MakeMediaUrl(brandName, "jpg", brandId) %>"/></p>
    
    <!-- Display the product price -->
    <p>Price: 
      <%= GeoTarget.IsRegionCode("CA") ? 
            String.Format("{0:c} CAD", productPrice * (decimal)1.17) : 
            String.Format("{0:c} USD", productPrice)  %>
    </p>
    
    <!-- Add to cart button and label -->
    <p>
      <asp:Button ID="addToCartButton" runat="server" Text="Add to Cart" OnClick="addToCartButton_Click" />
      <asp:Label ID="cartLabel" runat="server" />
    </p>
    
    <!-- Link to the primary category of the product -->
    View more products in our 
    <a href="<%= LinkFactory.MakeCategoryUrl(primaryCategoryName, primaryCategoryId) %>">
      <%= primaryCategoryName %></a>
    category.
  </form>
</body>
</html>
