<%@ WebHandler Language="C#" Class="Robots" %>
using System.Web;
using System.Data;

public class Robots : IHttpHandler
{
  public void ProcessRequest(HttpContext context)
  {
    // get the current HttpResponse object
    HttpResponse response = context.Response;
    
    // set the proper content type and send the Disallow line
    response.ContentType = "text/plain";
    response.Write("User-agent: * \n");
    
    // declare necessary variables
    string productId, productName, categoryId, categoryName, url;
    
    // retrieve the product categories that need to be excluded
    DataTable toExcludeTable = CatalogDb.GetSecondaryProductCategories();
    
    // parse the list of products and categories and exclude their links
    foreach (DataRow row in toExcludeTable.Rows)
    {
      // get data from the data row
      productId = row["ProductID"].ToString();
      productName = row["ProductName"].ToString();
      categoryId = row["SecondaryCategoryID"].ToString();
      categoryName = row["SecondaryCategoryName"].ToString();
      
      // use the link factory to obtain the URL
      url = LinkFactory.MakeCategoryProductUrl(categoryName, categoryId,
                                               productName, productId);
      
      // remove the domain name from the URL
      url = url.Replace(UrlTools.SiteDomain, "");
      
      // send url to the output to exclude it      
      response.Write(string.Format("Disallow: {0} \n", url));
    }
    
    // include the static exclusion data from robots_static.txt
    context.Response.WriteFile("~/robots_static.txt");
  }

  public bool IsReusable
  {
    get { return false; }
  }
}