﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.OleDb;
namespace DAL
{
   public class DALactive
    {
      

        /// <summary>
        /// 活动
        /// </summary>
        /// <param name="active"></param>

        #region 插入
        public void Insert(MODEL.Active active)
        {
            string sql = @"insert into ACTIVE(activeName,activeInfo,activeAgreeNum) values(@activeName,@activeInfo,@activeAgreeNum)";
            OleDbParameter[] SqlParams ={
                new OleDbParameter("@activeName",active.ActiveName),
                new OleDbParameter("@activeInfo",active.ActiveInfo),
                new OleDbParameter("@activeAgreeNum",active.ActiveAgreeNum)
            };
            SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);
        }
        #endregion

        #region 更新
        public void Update(MODEL.Active active)
        {
            string sql = "update ACTIVE set activeName=@activeName,activeInfo=@activeInfo,activeAgreeNum=@activeAgreeNum where activeID=@activeID";
            OleDbParameter[] SqlParams ={ 
                new OleDbParameter("@activeName",active.ActiveName),
                new OleDbParameter("@activeInfo",active.ActiveInfo),
                new OleDbParameter("@activeAgreeNum",active.ActiveAgreeNum),
                new OleDbParameter("@activeID",active.ActiveID)
            };
            SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);

        }
        #endregion

        #region 删除
        public void Delete(MODEL.Active active)
        {
            string sql = "delete from ACTIVE where activeID=@activeID";
            OleDbParameter[] SqlParams ={ new OleDbParameter("@activeID", active.ActiveID) };
            SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);
        }
        #endregion

       public MODEL.Active getActiveModel(int id)
       {
           string sql = "select * from ACTIVE where activeID=@id";
           OleDbParameter[] sp ={
           new OleDbParameter("@id",id)
           };
           MODEL.Active active = new MODEL.Active();
           OleDbDataReader read = DbConn.getReader(sql, sp);
           if (read.Read())
           {
               active.ActiveAgreeNum = Convert.ToInt32(read["activeAgreeNum"]);
               active.ActiveID = id;
               active.ActiveInfo = read["activeInfo"].ToString();
               active.ActiveName = read["activeName"].ToString();
           }
           read.Close();
           return active;
       }
     }
}
