﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.OleDb;
namespace DAL
{
   public class DALactiveInfo
    {
        /// <summary>
        /// MODEL--操作活动附表（存储用户投票信息，防止重复投票）
        /// </summary>

        #region 添加
        public void Insert(int actID,int empID)
        {
            string sql = "insert into ACTIVEINFO(activeID,employeeID) values(@activeID,@employeeID)";
            OleDbParameter[] SqlParams ={ 
               new OleDbParameter("@activeID",actID),
               new OleDbParameter("@employeeID",empID)
          };
            SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);
        }

        #endregion

        #region 更新
        public void Update(MODEL.ActiveInfo activeInfo)
        {
            string sql = "update ACTIVEINFO set activeID=@activeID,employeeID=@employeeID where ID=@ID";
            OleDbParameter[] SqlParams ={ 
               new OleDbParameter("@activeID",activeInfo.ActiveID),
               new OleDbParameter("@employeeID",activeInfo.EmployeeID),
               new OleDbParameter("@ID",activeInfo.ID)
          };
            SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);
        }
        #endregion

        #region 删除
        public void Delete(MODEL.ActiveInfo activeInfo)
        {
            string sql = "delete from ACTIVEINFO where ID=@ID";
            OleDbParameter[] SqlParams ={ 
          new OleDbParameter("@ID",activeInfo.ID)
          };
            SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);
        }
        #endregion
      
         #region 验证
       public bool checkActive(int actID,int empID)
       {
           string sql = "select count(*) from ACTIVEINFO where activeID=@actID and employeeID=@id";
           OleDbParameter[] sp={
                   new OleDbParameter("@actID",actID),
                   new OleDbParameter("@id",empID)
           };

           int i = SqlHelper.ExecuteQuery(DbConn.GetConnectionString(), sql, sp);
           if (i > 0)
           {
               return false;
           }
           else
           {
               return true;
           }
       }
         #endregion


    }
}
//5/1/as|px
