﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.OleDb;
namespace DAL
{
   public class DALdept
    {
        /// <summary>
        /// 部门
        /// </summary>
        #region 添加
        public void Insert(MODEL.Dept dept)
        {
            string sql = "insert into DEPT(deptName,deptText) values(@deptName,@deptText)";
            OleDbParameter[] SqlParams ={
                new OleDbParameter("@deptName",dept.DeptName),
                new OleDbParameter("@deptText",dept.DeptIntroduce)
            };
            SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);
        }
        #endregion

        #region 更新
        public void Update(MODEL.Dept dept)
        {
            string sql = "update DEPT set deptName=@deptName,deptText=@deptText where deptID=@deptID";
            OleDbParameter[] SqlParams ={           
                new OleDbParameter("@deptName",dept.DeptName),
                new OleDbParameter("@deptText",dept.DeptIntroduce),
                    new OleDbParameter("@deptID",dept.DeptID)
            };
            SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);
        }
        #endregion

        #region 删除
        public void Delete(MODEL.Dept dept)
        {
            string sql = "delete from DEPT where deptID=@deptID";
            OleDbParameter[] SqlParams ={
                new OleDbParameter("@deptID",dept.DeptID)
            };
            SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);
        }
        #endregion
        #region 查询
       public DataSet getDept()
       {
           string sql = "select * from DEPT";
           return DbConn.getData(sql);
       }
       public MODEL.Dept getDeptModel(int id)
       {
           string sql = "select deptName,deptText from DEPT where deptID= @id";
           OleDbParameter[] sp ={
           new OleDbParameter("@id",id)
           };
           OleDbDataReader read=DbConn.getReader(sql,sp);
           MODEL.Dept dept = new MODEL.Dept();
           if (read.Read())
           {
               dept.DeptID = id;
               dept.DeptName = read["deptName"].ToString();
               dept.DeptIntroduce = read["deptText"].ToString();
           }
           read.Close();
           return dept;
       }
        #endregion

       #region 验证
       public bool checkDept(string name)
       {
           string sql = "select count(*) from DEPT where deptName=@name";
           OleDbParameter[] sqlParaeter ={ new OleDbParameter("@name",name)};
          int i =  SqlHelper.ExecuteQuery(DbConn.GetConnectionString(), sql, sqlParaeter);
          if (i > 0)
          {
              return false;  //验证不通过
          }
          else
          {
              return true;  //通过验证
          }

       }
       #endregion
   }
}
