﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.OleDb;
using MODEL;
namespace DAL
{
   public class DALemployee
   {
       #region 验证
       /// <summary>
       /// 验证用户密码
       /// </summary>
       /// <param name="user"></param>
       /// <param name="password"></param>
       /// <returns></returns>
    
        public string loginUserLevel(string user,string password)
        {
            string sql = "select userLevel from EMPLOYEES where employeeName=@user and pwd=@pwd";
            OleDbParameter[] para ={ 
                            new OleDbParameter("@user",user),
                            new OleDbParameter("@pwd",password)
            };
            
            OleDbDataReader reader = DbConn.getReader(sql,para);
            if (reader.Read())
            {
                return reader["userLevel"].ToString();
            }
            else
            {
                return "0";
            }
        }
       /// <summary>
       /// 用户登陆权限
       /// </summary>
       /// <param name="userName"></param>
       /// <returns></returns>
       public string loginUserLevel(string userName)
       {
           string sql = "select userLevel from EMPLOYEES where employeeName=@user";
           OleDbParameter[] para ={ 
                            new OleDbParameter("@user",userName),
            };

           OleDbDataReader reader = DbConn.getReader(sql, para);
           if (reader.Read())
           {
               return reader["userLevel"].ToString();
           }
           else
           {
               return "0";
           }
       }
       #endregion
       //添加，删除，修改
        #region 插入
        public void Insert(MODEL.Employee emp)
        {
            string sql = @"insert into EMPLOYEES(employeeName,sex,birthday,address,NOcode,learn,mobile,email,jobID,deptID,workState,photo,agreement,userLevel)
                                      values(@employeeName,@sex,@birthday,@address,@NO,@learn,@mobile,@email,
                                             @jobID,@deptID,@workState,@photo,@agreeMent,@userLevel)";
            OleDbParameter[] SqlParams ={            
               new OleDbParameter("@employeeName",emp.EmployeeName),
               new OleDbParameter("@sex",emp.Sex),
               new OleDbParameter("@birthday",emp.Birthday),
               new OleDbParameter("@address",emp.Address),
               new OleDbParameter("@NO",emp.NO),
               new OleDbParameter("@learn",emp.Learn),
               new OleDbParameter("@mobile",emp.Mobile),
               new OleDbParameter("@email",emp.Email),
               new OleDbParameter("@jobID",emp.JobID),
               new OleDbParameter("@deptID",emp.DeptID),
               new OleDbParameter("@workState",emp.WorkState),
               new OleDbParameter("@photo",emp.Photo),
               new OleDbParameter("@agreeMent",emp.AgreeMent),
               new OleDbParameter("@userLevel",emp.UserLevel)
           };

            SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);


        }
        #endregion


        #region 更新
       public void Update(MODEL.Employee emp)
        {
            string sql = @"update EMPLOYEES set employeeName=@employeeName,sex=@sex,birthday=@birthday,address=@address,
                                          NOcode=@NO,learn=@learn,mobile=@mobile,email=@email,jobID=@jobID,deptID=@deptID,workState=@workState,
                                          photo=@photo,agreement=@agreeMent,pwd=@pwd,userLevel=@userLevel
                                          where employeeID=@employeeID";
            OleDbParameter[] SqlParams ={
               new OleDbParameter("@employeeName",emp.EmployeeName),
               new OleDbParameter("@sex",emp.Sex),
               new OleDbParameter("@birthday",emp.Birthday),
               new OleDbParameter("@address",emp.Address),
               new OleDbParameter("@NO",emp.NO),
               new OleDbParameter("@learn",emp.Learn),
               new OleDbParameter("@mobile",emp.Mobile),
               new OleDbParameter("@email",emp.Email),
               new OleDbParameter("@jobID",emp.JobID),
               new OleDbParameter("@deptID",emp.DeptID),
               new OleDbParameter("@workState",emp.WorkState),
               new OleDbParameter("@photo",emp.Photo),
               new OleDbParameter("@agreeMent",emp.AgreeMent),
               new OleDbParameter("@pwd",emp.Pwd),
               new OleDbParameter("@userLevel",emp.UserLevel),
               new OleDbParameter("@employeeID",emp.EmployeeID)
           };
           SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);

        }
        #endregion

        #region 删除
       public void Delete(MODEL.Employee emp)
        {
            string sql = "delete from EMPLOYEES where employeeID=@employeeID";
            OleDbParameter[] SqlParams ={ new OleDbParameter("@employeeID", emp.EmployeeID) };
            SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);

        }
        #endregion
        /// <summary>
        /// 这个是为了方便绑定数据
        /// </summary>
        /// <param name="empName"></param>
        /// <returns></returns>
        #region  select
       public DataSet getEmp(string empName)
       {
           string sql = @"select * from EMPLOYEES,DEPT,JOB WHERE EMPLOYEES.deptID=DEPT.deptID and EMPLOYEES.jobID=JOB.jobID and employeeName=@name";
           OleDbParameter[] Sqlparams ={
              new OleDbParameter("@name",empName)
           };
           return DbConn.getData(sql, Sqlparams);
       }
       public DataSet getEmp(int id)
       {
           string sql = @"select * from EMPLOYEES,DEPT,JOB WHERE EMPLOYEES.deptID=DEPT.deptID and EMPLOYEES.jobID=JOB.jobID and employeeID=@employeeID";
           OleDbParameter[] Sqlparams ={
              new OleDbParameter("@employeeID",id)
           };
           return DbConn.getData(sql, Sqlparams);
       }
       /// <summary>
       /// 获取在线用户信息
       /// </summary>
       /// <param name="online"></param>
       /// <returns></returns>
       public DataSet OnLine()
       {
           string sql = @"select employeeID,employeeName,deptName,jobName,photo from EMPLOYEES,DEPT,JOB WHERE EMPLOYEES.deptID=DEPT.deptID and EMPLOYEES.jobID=JOB.jobID and onLine='1'";
           return DbConn.getData(sql);
       }
       /// <summary>
       /// 获取员工实体 重载两个方法
       /// </summary>
       /// <param name="id"></param>
       /// <returns></returns>
       public MODEL.Employee getModel(int id)
       {
           string sql = @"select [employeeName],[sex], [birthday],[address],[NOcode],[learn],[mobile],[email],[jobID],[deptID],[workState],[photo],[agreement],[pwd],[userLevel],[onLine]
                  from EMPLOYEES where employeeID=@id";
           OleDbParameter[] Sqlparams ={
              new OleDbParameter("@id",id)
           };
           MODEL.Employee empModel = new Employee();
           OleDbDataReader read = DbConn.getReader(sql, Sqlparams);
           if (read.Read())
           {
               empModel.Address = read["address"].ToString();
               empModel.AgreeMent = read["agreement"].ToString();
               empModel.Birthday = Convert.ToDateTime(read["birthday"] == DBNull.Value ? null : read["birthday"]);
               empModel.DeptID = Convert.ToInt32(read["deptID"]);
               empModel.JobID = Convert.ToInt32(read["jobID"]);
               empModel.Mobile = read["mobile"].ToString();
               empModel.NO = read["NOcode"].ToString();
               empModel.OnLine = read["onLine"].ToString();
               empModel.Photo = read["photo"].ToString();
               empModel.Pwd = read["pwd"].ToString();
               empModel.Sex = read["sex"].ToString();
               empModel.UserLevel = read["userLevel"].ToString();
               empModel.WorkState = read["workState"].ToString();
               empModel.EmployeeName = read["employeeName"].ToString();
               empModel.Learn = read["learn"].ToString();
               empModel.Email = read["email"].ToString();
               empModel.EmployeeID = id;
           }
           read.Close();
           return empModel;
       }

      
       public MODEL.Employee getModel(string name)
       {
           string sql = @"select [employeeID],[sex], [birthday],[address],[NOcode],[learn],[mobile],[email],[jobID],[deptID],[workState],[photo],[agreement],[pwd],[userLevel],[onLine]
                  from EMPLOYEES where employeeName=@name";
           OleDbParameter[] Sqlparams ={
              new OleDbParameter("@name",name)
           };
           MODEL.Employee empModel = new Employee();
           OleDbDataReader read = DbConn.getReader(sql, Sqlparams);
           if (read.Read())
           {
               empModel.Address = read["address"].ToString();
               empModel.AgreeMent = read["agreement"].ToString();
               empModel.Birthday = Convert.ToDateTime(read["birthday"] == DBNull.Value ? null : read["birthday"]);
               empModel.DeptID = Convert.ToInt32(read["deptID"]);
               empModel.JobID = Convert.ToInt32(read["jobID"]);
               empModel.Mobile = read["mobile"].ToString();
               empModel.NO = read["NOcode"].ToString();
               empModel.OnLine = read["onLine"].ToString();
               empModel.Photo = read["photo"].ToString();
               empModel.Pwd = read["pwd"].ToString();
               empModel.Sex = read["sex"].ToString();
               empModel.UserLevel = read["userLevel"].ToString();
               empModel.WorkState = read["workState"].ToString();
               empModel.EmployeeName = name;
               empModel.Learn = read["learn"].ToString();
               empModel.Email = read["email"].ToString();
               empModel.EmployeeID =Convert.ToInt32(read["employeeID"]);
           }
           read.Close();
           return empModel;
       }
        #endregion
   








        /// <summary>
       /// 更新在线状态
       /// </summary>
       /// <param name="Online"></param>
       /// <param name="userName"></param>
       public void getOnline(string Online, string userName)
       { 
         string sql="update EMPLOYEES set onLine='"+Online+"' where employeeName='"+userName+"'";
         SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql);
       }
      
    }
}
