﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.OleDb;
namespace DAL
{
    public class DALfile
    {
        /// <summary>
        /// 文件
        /// </summary>
        #region 添加
        public void Insert(MODEL.File getfile)
        {
            string sql = @"insert into FILE(fileTime,fileText,fileFrom,fileTo,fileName) 
                                        values(@fileTime,@fileText,@fileFrom,@fileTo,@fileName)";
            OleDbParameter[] SqlParams ={
                new OleDbParameter("@fileTime",getfile.FileTime),
                new OleDbParameter("@fileText",getfile.FileText),
                new OleDbParameter("@fileFrom",getfile.FileFrom),
                new OleDbParameter("@fileTo",getfile.FileTo),
                new OleDbParameter("@fileName",getfile.FileName)
            };
            SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);
        }
        #endregion

        #region 更新
        public void Update(MODEL.File getfile)
        {
            string sql = @"update FILE set fileTime=@fileTime,fileText=@fileText,fileFrom=@fileFrom,
                                              fileTo=@fileTo,fileName=@fileName where fileID=@fileID";
            OleDbParameter[] SqlParams ={
                new OleDbParameter("@fileTime",getfile.FileTime),
                new OleDbParameter("@fileText",getfile.FileText),
                new OleDbParameter("@fileFrom",getfile.FileFrom),
                new OleDbParameter("@fileTo",getfile.FileTo),
                new OleDbParameter("@fileName",getfile.FileName),
                new OleDbParameter("@fileID",getfile.FileID)         
            };
            SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);
        }
        #endregion

        #region 删除
        public void Delete(MODEL.File getfile)
        {
            string sql = "delete from FILE where fileID=@fileID";
            OleDbParameter[] SqlParams ={
                new OleDbParameter("@fileID",getfile.FileID)
            };
            SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);
        }
        #endregion
        /// <summary>
        /// 文件实体
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public MODEL.File getFileModel(int id)
        {
            string sql = "select * from FILE where fileID=@id";
            OleDbParameter[] sp ={
           new OleDbParameter("@id",id)
           };
            MODEL.File files = new MODEL.File();
            OleDbDataReader read = DbConn.getReader(sql, sp);
            if (read.Read())
            {
                files.FileID = id;
                files.FileName = read["fileName"].ToString();
                files.FileText = read["fileText"].ToString();
                files.FileTime = Convert.ToDateTime(read["fileTime"]);
                files.FileFrom = Convert.ToInt32(read["fileFrom"]);
                files.FileTo = Convert.ToInt32(read["fileTo"]);

            }
            read.Close();
            return files;
        }
    }
}
