﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.OleDb;
namespace DAL
{
   public class DALjob
    {

        /// <summary>
        /// 职位
        /// </summary>
        #region 添加
        public void Insert(MODEL.Job job)
        {
            string sql = "insert into JOB(deptID,jobName,jobText) values(@deptID,@jobName,@jobText)";
            OleDbParameter[] SqlParams ={
                new OleDbParameter("@deptID",job.DeptID),
                new OleDbParameter("@jobName",job.JobName),
                new OleDbParameter("@jobText",job.JobIntroduce)
            };
            SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);
        }
        #endregion

        #region 更新
        public void Update(MODEL.Job job)
        {
            string sql = "update JOB set deptID=@deptID,jobName=@jobName,jobText=@jobText where jobID=@jobID";
            OleDbParameter[] SqlParams ={             
                new OleDbParameter("@deptID",job.DeptID),
                new OleDbParameter("@jobName",job.JobName),
                new OleDbParameter("@jobText",job.JobIntroduce),
                  new OleDbParameter("@jobID",job.JobID)
            };
            SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);
        }
        #endregion

        #region 删除
        public void Delete(MODEL.Job job)
        {
            string sql = "delete from JOB where jobID=@jobID";
            OleDbParameter[] SqlParams ={
                new OleDbParameter("@jobID",job.JobID)
            };
            SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);
        }
        #endregion

        #region 查询
       public DataSet getJobName(int id)
       {
           string sql = "select jobID,jobName from JOB where deptID=" + id;
           return DbConn.getData(sql);

       
       }
       

       public MODEL.Job getDeptModel(int id)
       {
           string sql = "select * from JOB where jobID=@id";
           OleDbParameter[] sp ={
           new OleDbParameter("@id",id)
           };
           MODEL.Job job = new MODEL.Job();
           OleDbDataReader read = DbConn.getReader(sql, sp);
           if (read.Read())
           {
               job.JobID = id;
               job.DeptID = Convert.ToInt32(read["deptID"]);
               job.JobName = read["jobName"].ToString();
               job.JobIntroduce = read["jobText"].ToString();
              
           }
           read.Close();
           return job;

       }
#endregion


       #region  验证
       public bool checkJob(string name)
       {
           string sql = "select count(*) from JOB where jobName=@name";
           OleDbParameter[] sqlParaeter ={ new OleDbParameter("@name", name) };
           int i = SqlHelper.ExecuteQuery(DbConn.GetConnectionString(), sql, sqlParaeter);
           if (i > 0)
           {
               return false;
           }
           else
           {
               return true;
           }
       }
       #endregion

   }
}


