﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.OleDb;
namespace DAL
{
   public class DALnotice
    {
        /// <summary>
        /// 公告
        /// </summary>
        #region 添加
        public void Insert(MODEL.Notice notice)
        {
            string sql = @"insert into NOTICE(employeeID,noteName,noteInfo,noteTime) 
                                        values(@employeeID,@noteName,@noteInfo,@noteTime)";
            OleDbParameter[] SqlParams ={
                new OleDbParameter("@employeeID",notice.EmployeeID),
                new OleDbParameter("@noteName",notice.NoteName),
                new OleDbParameter("@noteInfo",notice.NoteInfo),
                new OleDbParameter("@noteTime",notice.NoteTime)
            };
            SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);
        }
        #endregion

        #region 更新
        public void Update(MODEL.Notice notice)
        {
            string sql = @"update NOTICE set employeeID=@employeeID,noteName=@noteName,noteInfo=@noteInfo 
                                               where noteID=@noteID";
            OleDbParameter[] SqlParams ={
                new OleDbParameter("@employeeID",notice.EmployeeID),
                new OleDbParameter("@noteName",notice.NoteName),
                new OleDbParameter("@noteInfo",notice.NoteInfo),
                new OleDbParameter("@noteID",notice.NoteID)   
            };
            SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);
        }
        #endregion

        #region 删除
        public void Delete(MODEL.Notice notice)
        {
            string sql = "delete from NOTICE where noteID=@noteID";
            OleDbParameter[] SqlParams ={
                new OleDbParameter("@noteID",notice.NoteID)
            };
            SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);
        }
        #endregion
       public MODEL.Notice getNoteModel(int id)
       {
           string sql = "select * from NOTICE where noteID=@noteID";
           OleDbParameter[] SqlParams ={ new OleDbParameter("@noteID", id) };
           MODEL.Notice notice = new MODEL.Notice();
           OleDbDataReader read = DbConn.getReader(sql, SqlParams);
           if(read.Read())
           {
               notice.EmployeeID = Convert.ToInt32(read["employeeID"]);
               notice.NoteID = id;
               notice.NoteName = read["noteName"].ToString();
               notice.NoteTime = Convert.ToDateTime(read["noteTime"].ToString());
               notice.NoteInfo = read["noteInfo"].ToString();
           }
           read.Close();
           return notice;
       }
   }
}
