﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.OleDb;
namespace DAL
{
   public class DALtask
    {
        /// <summary>
        /// 工作任务
        /// </summary>
        #region 添加
        public void Insert(MODEL.Task task)
        {
            string sql = @"insert into TASK(taskName,taskInfo,getTime,taskState) 
                                        values(@taskName,@taskInfo,@getTime,@taskState)";
            OleDbParameter[] SqlParams ={
                new OleDbParameter("@taskName",task.TaskName),
                new OleDbParameter("@taskInfo",task.TaskInfo),
                new OleDbParameter("@getTime",task.GetTime),
                new OleDbParameter("@taskState",task.TaskState)
            };
            SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);
        }
        #endregion

        #region 更新
        public void Update(MODEL.Task task)
        {
            string sql = @"update TASK set taskName=@taskName,taskInfo=@taskInfo,getTime=@getTime,
                                              taskState=@taskState where taskID=@taskID";
            OleDbParameter[] SqlParams ={
                new OleDbParameter("@taskName",task.TaskName),
                new OleDbParameter("@taskInfo",task.TaskInfo),
                new OleDbParameter("@getTime",task.GetTime),
                new OleDbParameter("@taskState",task.TaskState),
                new OleDbParameter("@taskID",task.TaskID)         
            };
            SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);
        }
        #endregion

        #region 删除
        public void Delete(MODEL.Task task)
        {
            string sql = "delete from TASK where taskID=@taskID";
            OleDbParameter[] SqlParams ={
                new OleDbParameter("@taskID",task.TaskID)
            };
            SqlHelper.ExecuteNonQuery(DbConn.GetConnectionString(), sql, SqlParams);
        }
        #endregion
       #region  验证
       public bool checkTask(string name)
       {
           string sql = "select count(*) from TASK where taskName=@name";
           OleDbParameter[] sqlParaeter ={ new OleDbParameter("@name", name) };
           int i = SqlHelper.ExecuteQuery(DbConn.GetConnectionString(), sql, sqlParaeter);
           if (i > 0)
           {
               return false;
           }
           else
           {
               return true;
           }
       }
         #endregion
    }
}
//5/1/as|px