﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class UserControl_Edit : System.Web.UI.UserControl
{
 
    public MODEL.Employee employee;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            bindWorkDept();
            bindPage();
            bindWordJob();
           
        }
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        int id = Convert.ToInt32(Request.QueryString["id"]);
        employee = BLL.BLLemployee.getMobile(id);
        employee.EmployeeID=id;
        employee.Address = this.addTxt.Text;
        employee.EmployeeName = this.userName.Text;
        employee.JobID = Convert.ToInt32(this.jobList.SelectedValue);
        employee.DeptID = Convert.ToInt32(this.deptList.SelectedValue);
        employee.Email = this.email.Text;
        employee.Learn = this.learnList.SelectedItem.ToString();
        employee.Mobile = this.mobileTxt.Text;
        employee.NO = this.codeTxt.Text;
        employee.Photo = this.Image1.ImageUrl;
        employee.Sex = this.sexList.SelectedItem.ToString();
        employee.WorkState = this.stateList.SelectedItem.ToString();
        employee.UserLevel = this.levelList.SelectedValue;
        employee.Birthday = Convert.ToDateTime(this.birthTxt.Text);
        employee.AgreeMent = this.FCKeditor1.Value;
        BLL.BLLemployee.Update(employee);
        msgBox.putMsg("编辑成功","EditEmployee.aspx");
    }
  
    protected void Button2_Click(object sender, EventArgs e)
    {
        string fullName = this.fileUp.PostedFile.FileName.ToString();
        if (fullName == "")
        {
            msgBox.putMsg("请选择要上传的图片！");
            return;
        }
        if (this.userName.Text == "")
        {
            msgBox.putMsg("您至少应输入姓名才能上传头像！");
            return;
        }
        string imgType = fullName.Substring(fullName.LastIndexOf("."));
        if (imgType == ".jpg" || imgType == ".bmp" || imgType == ".gif")
        {

            ViewState["imgUrl"] = this.userName.Text + imgType;
            this.fileUp.PostedFile.SaveAs(Server.MapPath("~/photo/") + ViewState["imgUrl"]);
            this.Image1.ImageUrl = "~/photo/" + ViewState["imgUrl"];
        }
        else
        {
            msgBox.putMsg("只能上传jpg，gif，bmp格式图片！");
        }

    }
    protected void deptList_SelectedIndexChanged(object sender, EventArgs e)
    {
        bindWordJob();
    }
    public void bindWordJob()
    {
        int deptID = Convert.ToInt32(this.deptList.SelectedValue);
        DataSet ds = BLL.BLLjob.getJobName(deptID);
        this.jobList.DataSource = ds.Tables[0].DefaultView;
        this.jobList.DataTextField = "jobName";
        this.jobList.DataValueField = "jobID";
        this.jobList.DataBind();

    }
    public void bindWorkDept()
    {
        DataSet ds = BLL.BLLdept.Dept();
        this.deptList.DataSource = ds.Tables[0].DefaultView;
        this.deptList.DataTextField = "deptName";
        this.deptList.DataValueField = "deptID";
        this.deptList.DataBind();
    }
    protected void bindPage()
    {
        if (Request.QueryString["id"] != null)
        {
            int id = Convert.ToInt32(Request.QueryString["id"]);
            employee = BLL.BLLemployee.getMobile(id);
            this.addTxt.Text = employee.Address;
            this.userName.Text = employee.EmployeeName;
            this.jobList.SelectedValue = Convert.ToString(employee.JobID);
            this.deptList.SelectedValue = Convert.ToString(employee.DeptID);
            this.email.Text = employee.Email;
            this.learnList.Text = employee.Learn;
            this.mobileTxt.Text = employee.Mobile;
            this.codeTxt.Text = employee.NO;
            this.Image1.ImageUrl = employee.Photo;
            this.sexList.Text = employee.Sex;
            this.stateList.Text = employee.WorkState;
            this.levelList.SelectedValue = employee.UserLevel;
            this.birthTxt.Text = employee.Birthday.ToShortDateString();
            this.FCKeditor1.Value = employee.AgreeMent;
        }
        else
        {
            Response.Redirect("BOSS.aspx");
        }
    }
    protected void Button3_Click(object sender, EventArgs e)
    {
        Response.Redirect("BOSS.aspx");
    }
}
