﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class UserControl_EditDeptl : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            bindWorkDept();
            this.jobList.Items.Insert(0, "未选择");
        }
    }
    public void bindWordJob()
    {
        if (this.deptList.SelectedIndex == 0)
        {
            this.jobList.Items.Clear();
            this.jobList.Items.Insert(0, "未选择");
            return;
        }
        int deptID = Convert.ToInt32(this.deptList.SelectedValue);
        DataSet ds = BLL.BLLjob.getJobName(deptID);
        this.jobList.DataSource = ds.Tables[0].DefaultView;
        this.jobList.DataTextField = "jobName";
        this.jobList.DataValueField = "jobID";
        this.jobList.DataBind();
        this.jobList.Items.Insert(0, "新建部门");

    }
    public void bindWorkDept()
    {
        DataSet ds = BLL.BLLdept.Dept();
        this.deptList.DataSource = ds.Tables[0].DefaultView;
        this.deptList.DataTextField = "deptName";
        this.deptList.DataValueField = "deptID";
        this.deptList.DataBind();
        this.deptList.Items.Insert(0, "未选择");
    }

    protected void deptList_SelectedIndexChanged(object sender, EventArgs e)
    {
        bindWordJob();
    }
    protected void jobList_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (this.jobList.SelectedIndex != 0)
        {
            MODEL.Job job = BLL.BLLjob.getJobModel(Convert.ToInt32(this.jobList.SelectedValue));
            this.TextBox1.Text = job.JobName;
            this.TextBox2.Text = job.JobIntroduce;
        }
        else
        {
            this.TextBox1.Text = "";
            this.TextBox2.Text = "";
        }
    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        if (this.deptList.SelectedIndex != 0)
        {
            try
            {
                MODEL.Dept dept = BLL.BLLdept.getDeptModel(Convert.ToInt32(this.deptList.SelectedValue));
                getDelete.AllDelete("JOB", "deptID", Convert.ToInt32(this.deptList.SelectedValue));
                BLL.BLLdept.Delete(dept);
                msgBox.box("删除部门成功");
                bindWorkDept();
                this.jobList.Items.Insert(0, "未选择");
            }
            catch(Exception ex)
            {
                throw ex;
            }

        }
        else
        {
            msgBox.putMsg("请选择部门");
        }

    }
    protected void Button3_Click(object sender, EventArgs e)
    {
        if (this.jobList.SelectedIndex != 0)
        {
            MODEL.Job job = BLL.BLLjob.getJobModel(Convert.ToInt32(this.jobList.SelectedValue));
            BLL.BLLjob.Delete(job);
            int deptID = Convert.ToInt32(this.deptList.SelectedValue);
            DataSet ds = BLL.BLLjob.getJobName(deptID);
            this.jobList.DataSource = ds.Tables[0].DefaultView;
            this.jobList.DataTextField = "jobName";
            this.jobList.DataValueField = "jobID";
            this.jobList.DataBind();
            this.jobList.Items.Insert(0, "新建职位");
            this.TextBox1.Text = "";
            this.TextBox2.Text = "";
            msgBox.box("删除职位成功");
        }
        else
        {
            msgBox.putMsg("请选择职位");
        }
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        if(this.jobList.SelectedIndex==0)
        {
            if (this.CustomValidator1.IsValid == false)
            {
                msgBox.putMsg("职位名有重复！");
                return;
            }
            
            MODEL.Job job = new MODEL.Job();
            job.DeptID = Convert.ToInt32(this.deptList.SelectedValue);
            job.JobName = this.TextBox1.Text;
            job.JobIntroduce = this.TextBox2.Text;
            BLL.BLLjob.Insert(job);
            bindWordJob();
            msgBox.box("职位添加成功");
            this.TextBox1.Text = "";
            this.TextBox2.Text = "";
        }
         else
        {
            MODEL.Job jb = BLL.BLLjob.getJobModel(Convert.ToInt32(this.jobList.SelectedValue));
            jb.JobName = this.TextBox1.Text;
            jb.JobIntroduce = this.TextBox2.Text;
            jb.DeptID = Convert.ToInt32(this.jobList.SelectedValue);
            BLL.BLLjob.Update(jb);
            bindWordJob();
            msgBox.box("职位更新成功");
            this.TextBox1.Text = "";
            this.TextBox2.Text = "";
        }

    }
    protected void CustomValidator1_ServerValidate(object source, ServerValidateEventArgs args)
    {
        if (BLL.BLLjob.checkJob(args.Value) == false)
        {
            args.IsValid = false;
        }
        else

        {
            args.IsValid = true;
        }

    }
}
