﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.OleDb;

public partial class UserControl_AddUserl : System.Web.UI.UserControl
{
    public MODEL.Employee employee = new MODEL.Employee();
    protected void Page_Load(object sender, EventArgs e)
    {

        if (!IsPostBack)
        {
            bindWorkDept();
            this.jobList.Items.Insert(0, "未选择");
            ViewState["imgUrl"] = "newEmployee.jpg";
        }
    }
    public void bindWordJob()
    {
        if (this.deptList.SelectedValue == "未选择")
        {
            this.jobList.Items.Clear();
            this.jobList.Items.Insert(0, "未选择");
            return;
        }
        int deptID = Convert.ToInt32(this.deptList.SelectedValue);
        DataSet ds = BLL.BLLjob.getJobName(deptID);
        this.jobList.DataSource = ds.Tables[0].DefaultView;
        this.jobList.DataTextField = "jobName";
        this.jobList.DataValueField = "jobID";
        this.jobList.DataBind();

    }
    public void bindWorkDept()
    {
        DataSet ds = BLL.BLLdept.Dept();
        this.deptList.DataSource = ds.Tables[0].DefaultView;
        this.deptList.DataTextField = "deptName";
        this.deptList.DataValueField = "deptID";
        this.deptList.DataBind();
        this.deptList.Items.Insert(0, "未选择");
    }
    protected void deptList_SelectedIndexChanged(object sender, EventArgs e)
    {
        // bindWorkDept();
        bindWordJob();
    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        string fullName = this.fileUp.PostedFile.FileName.ToString();
        if (fullName == "")
        {
            msgBox.putMsg("请选择要上传的图片！");
            return;
        }
        if (this.userName.Text == "")
        {
            msgBox.putMsg("您至少应输入姓名才能上传头像！");
            return;
        }
        string imgType = fullName.Substring(fullName.LastIndexOf("."));
        if (imgType == ".jpg" || imgType == ".bmp" || imgType == ".gif")
        {

            ViewState["imgUrl"] = this.userName.Text + imgType;
            this.fileUp.PostedFile.SaveAs(Server.MapPath("~/photo/") + ViewState["imgUrl"]);
            this.Image1.ImageUrl = "~/photo/" + ViewState["imgUrl"];
        }
        else
        {
            msgBox.putMsg("只能上传jpg，gif，bmp格式图片！");
        }

    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        if (this.CustomValidator1.IsValid == false)
        {
            msgBox.putMsg("用户名有重复请重新输入！");
            return;
        }
        if (this.jobList.SelectedValue=="未选择" || this.deptList.SelectedValue=="未选择")
        {
            msgBox.putMsg("请选择部门和职位");
            return;
        }
        employee.Address = this.addTxt.Text;
        employee.EmployeeName = this.userName.Text;
        employee.JobID = Convert.ToInt32(this.jobList.SelectedValue);
        employee.DeptID = Convert.ToInt32(this.deptList.SelectedValue);
        employee.Email = this.email.Text;
        employee.Learn = this.learnList.SelectedItem.ToString();
        employee.Mobile = this.mobileTxt.Text;
        employee.NO = this.codeTxt.Text;
        employee.Photo = "~/photo/" + ViewState["imgUrl"];
        employee.Sex = this.sexList.SelectedItem.ToString();
        employee.WorkState = this.stateList.SelectedItem.ToString();
        employee.UserLevel = this.levelList.SelectedValue;
        employee.Birthday = Convert.ToDateTime(this.birthTxt.Text);
        employee.AgreeMent = "暂无";
        BLL.BLLemployee.Insert(employee);
        msgBox.putMsg("添加成功", "AddEmployee.aspx");
    }
    protected void CustomValidator1_ServerValidate(object source, ServerValidateEventArgs args)
    {
        string name = args.Value;
        string getLevel = BLL.check.checkUserName(name);
        if (getLevel != "0")
        {
            args.IsValid = false;
        }
        else
        {
            args.IsValid = true;
        }
    }
}
