﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.IO;

namespace Eshop.Web.UI
{
    /// <summary>
    /// 静态网页保存
    /// </summary>
    public class FilterStream : Stream
    {
        private Stream respStream = null;
        private Stream fileStream = null;

        public FilterStream(Stream respStream, string filePath)
        {
            if (respStream == null)
                throw new ArgumentNullException("输出流不能为空");

            this.respStream = respStream;
            
            try
            {
                this.fileStream = new FileStream(filePath, FileMode.Create, FileAccess.Write);  //写入到文件夹中
            }
            catch { }
        }


        public override bool CanRead
        {
            get { return this.respStream.CanRead; }
        }

        public override bool CanSeek
        {
            get { return this.respStream.CanSeek; }
        }

        public override bool CanWrite
        {
            get { return this.respStream.CanWrite; }
        }

        public override void Flush()
        {
            this.respStream.Flush();

            if (this.fileStream != null)
            {
                this.fileStream.Flush();
            }
        }

        public override long Length
        {
            get { return this.respStream.Length; }
        }

        public override long Position
        {
            get
            {
                return this.respStream.Position;
            }
            set
            {
                this.respStream.Position = value;

                if (this.fileStream != null)
                {
                    this.fileStream.Position = value;
                }
            }
        }

        public override int Read(byte[] buffer, int offset, int count)
        {
            return this.respStream.Read(buffer, offset, count);
        }

        public override long Seek(long offset, SeekOrigin origin)
        {
            if (this.fileStream != null)
            {
                this.fileStream.Seek(offset, origin);
            }

            return this.respStream.Seek(offset, origin);
        }

        public override void SetLength(long value)
        {
            this.respStream.SetLength(value);

            if (this.fileStream != null)
            {
                this.fileStream.SetLength(value);
            }
        }

        public override void Write(byte[] buffer, int offset, int count)
        {
            this.respStream.Write(buffer, offset, count);

            if (this.fileStream != null)
            {
                this.fileStream.Write(buffer, offset, count);
            }
        }

        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);

            this.respStream.Dispose();
            if (this.fileStream != null)
            {
                this.fileStream.Dispose();
            }
        }
    }
}
