﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.IO;

namespace Eshop.Web.UI  
{
    /// <summary>
    /// 后缀为HTML的，都经这里处理
    /// web.config
    /// <remove verb="*" path="*.HTML"/>
    /// <add verb="*" path="*.HTML" type="Eshop.Web.UI.HtmlHandler,AspxToHtmlDemo"/>
    /// </summary>
    public class HtmlHandler:IHttpHandler
    {
        public bool IsReusable
        {
            get { return false; }
        }

        /// <summary>
        /// 获取物理路径，判断文件夹中有没有存在这个文件
        /// 不存在的话，就会调用FilterStream类进行创建,并写入内容
        /// 存在的话，就直接显示页面
        /// </summary>
        public void ProcessRequest(HttpContext context)
        {
            HttpRequest request = context.Request;
            HttpResponse response = context.Response;

            string htmlPage = request.RawUrl;
            string htmlFile = context.Server.MapPath(htmlPage);

            if (File.Exists(htmlFile))
            {
                response.WriteFile(htmlFile);
                return;
            }

            //Html 文件不存在
            string aspxPage = UrlMapping.HtmlToAspx(htmlPage);
            response.Redirect(aspxPage);
        }

    }
}
