﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.IO;

namespace Eshop.Web.UI
{
    /// <summary>
    /// 哪个页面想静态化，就继承这个类
    /// </summary>
    public class HtmlPage:Page
    {
        // <summary>
        /// 获取物理路径，判断文件夹中有没有存在这个文件
        /// 不存在的话，就会调用FilterStream类进行创建,并写入内容
        /// 存在的话，就直接显示页面
        /// </summary>
        public override void ProcessRequest(HttpContext context)
        {
            HttpRequest req = context.Request;
            HttpResponse resp = context.Response;

            string htmlPage = UrlMapping.AspxToHtml(req.RawUrl);
            string htmlFile = context.Server.MapPath(htmlPage);

            if (File.Exists(htmlFile))
            {
                resp.Redirect(htmlPage);
                return;
            }

            // Html 页面不存在
            resp.Filter = new FilterStream(resp.Filter, htmlFile);
            base.ProcessRequest(context);
        }
    }
}
