﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.IO;

namespace Eshop.Web.UI
{
    /// <summary>
    /// 路径映射
    /// </summary>
    public static class UrlMapping
    {
        //Aspx 转换到 Html
        public static string AspxToHtml(string url)
        {
            //判断路径是否为空
            if (string.IsNullOrEmpty(url))
            {
                throw new ArgumentNullException("路径不能为空");
            }

            //分割路径
            string[] temp = url.Split('?');

            if (temp.Length != 1 && temp.Length != 2)
            {
                throw new ArgumentException(String.Format("路径 {0} 及其参数错误", url));
            }

            //获取路径后缀
            string ext = Path.GetExtension(temp[0]);    
            if (!(ext.Equals(".aspx", StringComparison.OrdinalIgnoreCase)))
            {
                throw new ArgumentException(String.Format("路径 {0} 类型必须为ASPX", url));
            }

            //截取.aspx中前面的内容
            int offset = temp[0].LastIndexOf('.');
            string resource = temp[0].Substring(0, offset);

            //路径不带参数时
            if (temp.Length == 1 || string.IsNullOrEmpty(temp[1]))
            {
                return string.Format("{0}.html", resource);    //拼接
            }

            //路径带参数时
            return string.Format("{0}___{1}.html", resource, temp[1]); //拼接
        }
        
        //Html 转换到 Aspx
        public static string HtmlToAspx(string url)
        {
            //判断路径是否为空
            if (string.IsNullOrEmpty(url))
            {
                throw new ArgumentNullException("路径不能为空");
            }

            string ext = Path.GetExtension(url);
            if (!(ext.Equals(".html", StringComparison.OrdinalIgnoreCase)))
            {
                throw new ArgumentException(String.Format("路径 {0} 类型必须为HTML", url));
            }

            string[] temp = url.Split(new String[] { "___", "." }, StringSplitOptions.RemoveEmptyEntries);
            if (temp.Length == 2)
            {
                return string.Format("{0}.aspx", temp[0]);
            }

            if (temp.Length == 3)
            {
                return String.Format("{0}.aspx?{1}", temp[0], temp[1]);
            }

            throw new ArgumentException(String.Format("资源 {0} 及其参数错误", url));
        }
    }
}
