﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using AphroditePiano.VO;
using System.Windows.Threading;
using AphroditePiano.Model;

namespace AphroditePiano.Controls
{
    public partial class AutoPlayManager : UserControl
    {
        public AutoPlayManager()
        {
            InitializeComponent();
            gapTimer.Tick += new EventHandler(gapTimer_Tick);
            paragraphTimer.Tick += new EventHandler(paragraphTimer_Tick);
        }

        #region PlaySpeed (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public double PlaySpeed
        {
            get { return (double)GetValue(PlaySpeedProperty); }
            set { SetValue(PlaySpeedProperty, value); }
        }
        public static readonly DependencyProperty PlaySpeedProperty =
            DependencyProperty.Register("PlaySpeed", typeof(double), typeof(AutoPlayManager),
            new PropertyMetadata(0.0, new PropertyChangedCallback(OnPlaySpeedChanged)));

        private static void OnPlaySpeedChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((AutoPlayManager)d).OnPlaySpeedChanged(e);
        }

        protected virtual void OnPlaySpeedChanged(DependencyPropertyChangedEventArgs e)
        {
            double tempValue = 0.4 - (double)e.NewValue;
            gapTimeSpan = TimeSpan.FromSeconds(tempValue);
            paragraphTimeSpan = TimeSpan.FromSeconds(tempValue * 2);
            gapTimer.Interval = gapTimeSpan;
            paragraphTimer.Interval = paragraphTimeSpan;
        }

        #endregion

        public TimeSpan gapTimeSpan = TimeSpan.FromSeconds(.4);
        public TimeSpan paragraphTimeSpan = TimeSpan.FromSeconds(.8);
        public DispatcherTimer gapTimer = new DispatcherTimer();
        public DispatcherTimer paragraphTimer = new DispatcherTimer();

        public string[] keys;

        public int keyIndex = 0;

        public void PlayMusic(MusicVO music)
        {
            StopMusic();
            keyIndex = 0;
            gapTimer.Interval = gapTimeSpan;
            paragraphTimer.Interval = paragraphTimeSpan;

            keys = music.PassKey.Split(',');


            gapTimer.Start();

        }
        public void StopMusic()
        {
            gapTimer.Stop();
            paragraphTimer.Stop();
            keyIndex = 0;
        }

        void paragraphTimer_Tick(object sender, EventArgs e)
        {
            paragraphTimer.Stop();
            gapTimer.Start();
        }

        void gapTimer_Tick(object sender, EventArgs e)
        {
            UpAllKeys();
            if (keyIndex < keys.Length - 1)
            {
                if (keys[keyIndex] != "|")
                {
                    string[] ks = keys[keyIndex].Split('&');
                    foreach (string k in ks)
                    {
                        DownKey(k);
                    }
                }
                else
                {
                    gapTimer.Stop();
                    paragraphTimer.Start();
                }
                keyIndex++;
            }
            else {
                gapTimer.Stop();
                paragraphTimer.Stop();
                keyIndex = 0;
            }
        }

        private void DownKey(string k) {
            switch (k) {
                case "Q":
                    SLKeyBoardModel.Instance.IsQDown = true;
                    break;
                case "W":
                    SLKeyBoardModel.Instance.IsWDown = true;
                    break;
                case "E":
                    SLKeyBoardModel.Instance.IsEDown = true;
                    break;
                case "R":
                    SLKeyBoardModel.Instance.IsRDown = true;
                    break;
                case "T":
                    SLKeyBoardModel.Instance.IsTDown = true;
                    break;
                case "Y":
                    SLKeyBoardModel.Instance.IsYDown = true;
                    break;
                case "U":
                    SLKeyBoardModel.Instance.IsUDown = true;
                    break;
                case "I":
                    SLKeyBoardModel.Instance.IsIDown = true;
                    break;
                case "O":
                    SLKeyBoardModel.Instance.IsODown = true;
                    break;
                case "P":
                    SLKeyBoardModel.Instance.IsPDown = true;
                    break;
                case "A":
                    SLKeyBoardModel.Instance.IsADown = true;
                    break;
                case "S":
                    SLKeyBoardModel.Instance.IsSDown = true;
                    break;
                case "D":
                    SLKeyBoardModel.Instance.IsDDown = true;
                    break;
                case "F":
                    SLKeyBoardModel.Instance.IsFDown = true;
                    break;
                case "G":
                    SLKeyBoardModel.Instance.IsGDown = true;
                    break;
                case "H":
                    SLKeyBoardModel.Instance.IsHDown = true;
                    break;
                case "J":
                    SLKeyBoardModel.Instance.IsJDown = true;
                    break;
                case "K":
                    SLKeyBoardModel.Instance.IsKDown = true;
                    break;
                case "L":
                    SLKeyBoardModel.Instance.IsLDown = true;
                    break;
                case "Z":
                    SLKeyBoardModel.Instance.IsZDown = true;
                    break;
                case "X":
                    SLKeyBoardModel.Instance.IsXDown = true;
                    break;
                case "C":
                    SLKeyBoardModel.Instance.IsCDown = true;
                    break;
                case "V":
                    SLKeyBoardModel.Instance.IsVDown = true;
                    break;
                case "B":
                    SLKeyBoardModel.Instance.IsBDown = true;
                    break;
                case "N":
                    SLKeyBoardModel.Instance.IsNDown = true;
                    break;
                case "M":
                    SLKeyBoardModel.Instance.IsMDown = true;
                    break;
            }
        }
        private void UpAllKeys() {
            SLKeyBoardModel.Instance.IsQDown = false;
            SLKeyBoardModel.Instance.IsWDown = false;
            SLKeyBoardModel.Instance.IsEDown = false;
            SLKeyBoardModel.Instance.IsRDown = false;
            SLKeyBoardModel.Instance.IsTDown = false;
            SLKeyBoardModel.Instance.IsYDown = false;
            SLKeyBoardModel.Instance.IsUDown = false;
            SLKeyBoardModel.Instance.IsIDown = false;
            SLKeyBoardModel.Instance.IsODown = false;
            SLKeyBoardModel.Instance.IsPDown = false;
            SLKeyBoardModel.Instance.IsADown = false;
            SLKeyBoardModel.Instance.IsSDown = false;
            SLKeyBoardModel.Instance.IsDDown = false;
            SLKeyBoardModel.Instance.IsFDown = false;
            SLKeyBoardModel.Instance.IsGDown = false;
            SLKeyBoardModel.Instance.IsHDown = false;
            SLKeyBoardModel.Instance.IsJDown = false;
            SLKeyBoardModel.Instance.IsKDown = false;
            SLKeyBoardModel.Instance.IsLDown = false;
            SLKeyBoardModel.Instance.IsZDown = false;
            SLKeyBoardModel.Instance.IsXDown = false;
            SLKeyBoardModel.Instance.IsCDown = false;
            SLKeyBoardModel.Instance.IsVDown = false;
            SLKeyBoardModel.Instance.IsBDown = false;
            SLKeyBoardModel.Instance.IsNDown = false;
            SLKeyBoardModel.Instance.IsMDown = false;
        }
    }
}
