﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
//５１ａsｐx
namespace AphroditePiano
{
	public partial class BtnKey : UserControl
	{

        #region KeyStr (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public string KeyStr
        {
            get { return (string)GetValue(KeyStrProperty); }
            set { SetValue(KeyStrProperty, value); }
        }
        public static readonly DependencyProperty KeyStrProperty =
            DependencyProperty.Register("KeyStr", typeof(string), typeof(BtnKey),
            new PropertyMetadata("  ", new PropertyChangedCallback(OnKeyStrChanged)));

        private static void OnKeyStrChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((BtnKey)d).OnKeyStrChanged(e);
        }

        protected virtual void OnKeyStrChanged(DependencyPropertyChangedEventArgs e)
        {
            BtnK.Content = e.NewValue;
        }

        #endregion


        #region KeyStates (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool KeyStates
        {
            get { return (bool)GetValue(KeyStatesProperty); }
            set { SetValue(KeyStatesProperty, value); }
        }
        public static readonly DependencyProperty KeyStatesProperty =
            DependencyProperty.Register("KeyStates", typeof(bool), typeof(BtnKey),
            new PropertyMetadata(false, new PropertyChangedCallback(OnKeyStatesChanged)));

        private static void OnKeyStatesChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((BtnKey)d).OnKeyStatesChanged(e);
        }

        protected virtual void OnKeyStatesChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue == true)
            {
                VisualStateManager.GoToState(this, "Down", true);
            }
            else
            {
                VisualStateManager.GoToState(this, "Normal", true);
            }
        }

        #endregion



		public BtnKey()
		{
			// Required to initialize variables
			InitializeComponent();
		}
	}
}